<?php
include 'enableCORS.php';
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Cls_exp_exc extends CI_Controller {
	
	function __construct() {
        enableCORS(); 
        parent::__construct();
        /* CARGAMOS LIBRERIAS PARA ESTE CONTROLLER*/       
        include(dirname(__FILE__)."/../libraries/PHPExcel/Classes/PHPExcel.php");  
         $this->load->helper('fnc_gnr_helper');              
    }

    Public Function fnc_exp_exc_per()
    {        
        /*[AUT-20190514 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                        
        
        /*[AUT-20190514 : Parametros de Entrada desde ExtJS]*/
        $iCodSdp = $data[0];
        $iTipOpe = $data[1];
        $iCodEsp = $data[2];
        $iCodTsc = $data[3];
        $iCodTpe = $data[4];
        $iCodPfs = $data[5];
        $iRutSdp = $data[6];
        $iRznScl = $data[7];
        $iNomFan = $data[8];

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);        
        
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion");                                      
        
        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado de Personas');        
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B2')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(15)
                    ->setBold(true)
                    ->getColor();        
               
        /*Centrar Celdas*/            
        $objPHPExcel->getActiveSheet()->getStyle('B5:I5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('B5', 'Código')
                    ->setCellValue('C5', 'Estado')
                    ->setCellValue('D5', 'Tipo de Persona')
                    ->setCellValue('E5', 'RUT')
                    ->setCellValue('F5', 'Nombre / Razón Social')
                    ->setCellValue('G5', 'Nombre de Fantasía')
                    ->setCellValue('H5', 'Fecha de Nacimiento')
                    ->setCellValue('I5', 'Profesión');                    

        //Configuración de tipos de letra                         
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:I5')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(true)        
                    ->getColor()
                    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
                    
        //fondo a celda
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:I5')
                    ->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('&H808080');         
        
        $personas = $this->mdl_exp_exc->mdl_csu_scd_per($iCodSdp,
                                                        $iTipOpe,
                                                        $iCodEsp,
                                                        $iCodTsc,
                                                        $iCodTpe,
                                                        $iCodPfs,
                                                        $iRutSdp,
                                                        $iRznScl,
                                                        $iNomFan);

        $Ct = 5;
        
        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(false)        
                    ->getColor();   
           
        foreach ($personas as $per)
        {
	        $Ct = $Ct + 1;

	        $objPHPExcel->setActiveSheetIndex(0)
	                        ->setCellValue('B' . $Ct, $per->tsp_cod_sdp)
                            ->setCellValue('C' . $Ct, $per->tes_des_esp)                           
	                        ->setCellValue('D' . $Ct, $per->ttp_des_tpe)                      
                            ->setCellValue('E' . $Ct, $per->tsp_rut_sdp . '-' . $per->tsp_dvf_sdp)                      
	                        ->setCellValue('F' . $Ct, $per->tsp_rzn_scl)                      
	                        ->setCellValue('G' . $Ct, $per->tsp_nom_fan)
	                        ->setCellValue('H' . $Ct, fcf_cmb_fec($per->tsp_fec_ian))
	                        ->setCellValue('I' . $Ct, $per->tmp_des_pfs);                                         
                        
        /*Centrar Celdas*/                
        $objPHPExcel->getActiveSheet()->getStyle('B' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);           
        $objPHPExcel->getActiveSheet()->getStyle('E' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);   
        $objPHPExcel->getActiveSheet()->getStyle('H' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);    

        }   
                              
        $objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
        //Unir celdas 
        $objPHPExcel->getActiveSheet()->mergeCells('B2:D2');
             
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(10);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);         
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true); 
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);    
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);      
             
                            
        $objPHPExcel->getActiveSheet()->setTitle('Exportacion');
        $objPHPExcel->setActiveSheetIndex(0);         
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Listado_de_Personas.xls"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       
        
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');      
    }  

    Public Function fnc_exp_exc_scd()
    {        
        /*[AUT-20190514 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                        
        
        /*[AUT-20190514 : Parametros de Entrada desde ExtJS]*/
        $iCodSdp = $data[0];
        $iTipOpe = $data[1];
        $iCodEsp = $data[2];
        $iCodTsc = $data[3];
        $iCodTpe = $data[4];
        $iCodPfs = $data[5];
        $iRutSdp = $data[6];
        $iRznScl = $data[7];
        $iNomFan = $data[8];

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);        
        
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion");                                      
        
        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado de Sociedades');        
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B2')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(15)
                    ->setBold(true)
                    ->getColor();        
               
        /*Centrar Celdas*/            
        $objPHPExcel->getActiveSheet()->getStyle('B5:I5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('B5', 'Código')
                    ->setCellValue('C5', 'Nombre / Razón Social')
                    ->setCellValue('D5', 'Estado')
                    ->setCellValue('E5', 'Motivo NO VIGENTE')                    
                    ->setCellValue('F5', 'RUT')
                    ->setCellValue('G5', 'Tipo Sociedad')                  
                    ->setCellValue('H5', 'Nombre de Fantasía')
                    ->setCellValue('I5', 'Capital Sociedad')
                    ->setCellValue('J5', 'Fecha Inicio Actividades')                                 
                    ->setCellValue('K5', 'Fusión')                    
                    ->setCellValue('L5', 'Empresas Fusionadas');                    

        //Configuración de tipos de letra                         
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:L5')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(true)        
                    ->getColor()
                    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
                    
        //fondo a celda
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:L5')
                    ->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('&H808080');         
        
        $sociedades = $this->mdl_exp_exc->mdl_csu_scd_per($iCodSdp,
                                                        $iTipOpe,
                                                        $iCodEsp,
                                                        $iCodTsc,
                                                        $iCodTpe,
                                                        $iCodPfs,
                                                        $iRutSdp,
                                                        $iRznScl,
                                                        $iNomFan);

        $Ct = 5;
        
        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(false)        
                    ->getColor();   
           
        foreach ($sociedades as $scd)
        {
            $Ct = $Ct + 1;

            $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('B' . $Ct, $scd->tsp_cod_sdp)
                            ->setCellValue('C' . $Ct, $scd->tsp_rzn_scl)                            
                            ->setCellValue('D' . $Ct, $scd->tes_des_esp)  
                            ->setCellValue('E' . $Ct, $scd->tsp_not_vig)
                            ->setCellValue('F' . $Ct, $scd->tsp_rut_sdp . '-' . $scd->tsp_dvf_sdp)                     
                            ->setCellValue('G' . $Ct, $scd->tts_des_tsc)                         
                            ->setCellValue('H' . $Ct, $scd->tsp_nom_fan)
                            ->setCellValue('I' . $Ct, $scd->tsp_cpl_scl) 
                            ->setCellValue('J' . $Ct, fcf_cmb_fec($scd->tsp_fec_ian)) 
                            ->setCellValue('K' . $Ct, $scd->tsp_emp_fus)
                            ->setCellValue('L' . $Ct, $scd->rzn_scl_fus);
                        
            /*Centrar Celdas*/                            
            $objPHPExcel->getActiveSheet()->getStyle('B' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);       
            $objPHPExcel->getActiveSheet()->getStyle('D' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);       
            $objPHPExcel->getActiveSheet()->getStyle('F' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);       
            
            $objPHPExcel->getActiveSheet()->getStyle('I' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);     
            $objPHPExcel->getActiveSheet()->getStyle('J' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);       
                       

            $objPHPExcel->getActiveSheet()
                        ->getStyle('D' . $Ct)
                        ->getFont()
                        ->setName('Calibri')
                        ->setSize(8)
                        ->setBold(true)        
                        ->getColor()
                        ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);  

            $objPHPExcel->getActiveSheet()
                        ->getStyle('D' . $Ct)
                        ->getFill()
                        ->applyFromArray(array(
                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                'startcolor' => array(
                                                    'rgb' => $scd->tes_bck_col
                                                )
                                ));
        }   
                              
        $objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
        //Unir celdas 
        $objPHPExcel->getActiveSheet()->mergeCells('B2:D2');
             
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(10);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);         
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true); 
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);  
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
             
                            
        $objPHPExcel->getActiveSheet()->setTitle('Exportacion');
        $objPHPExcel->setActiveSheetIndex(0);         
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Listado_de_Sociedades.xls"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       
        
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');      
    }  

     Public Function fnc_exp_exc_sol()
    {        
        /*[AUT-20190627 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                        
        
        /*[AUT-20190627 : Parametros de Entrada desde ExtJS]*/
        $iCodSpt = $data[0];
        $iFemIni = $data[1];
        $iFemTer = $data[2];
        $iCodEss = $data[3];
        $iEmiPor = $data[4];
        $iSolPor = $data[5];
        $iCodSdp = $data[6];
        $iCodTsl = $data[7];
        $iCodNpr = $data[8];
        $iFetIni = $data[9];
        $iFetTer = $data[10];
        $iVboSup = $data[11];
        $iCodRbr = $data[12];
        $iVboRbr = $data[13];

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);        
        
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion");                                      
        
        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado de Solicitudes');        
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B2')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(15)
                    ->setBold(true)
                    ->getColor();        
               
        /*Centrar Celdas*/            
        $objPHPExcel->getActiveSheet()->getStyle('B5:N5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('B5', 'N° Solicitud')
                    ->setCellValue('C5', 'Estado')
                    ->setCellValue('D5', 'Empresa')
                    ->setCellValue('E5', 'Asunto')
                    ->setCellValue('F5', 'Fecha Estimación')
                    ->setCellValue('G5', 'Fecha Emisión')
                    ->setCellValue('H5', 'Tipo')
                    ->setCellValue('I5', 'Emitido Por') 
                    ->setCellValue('J5', 'Solicitado Por') 
                    ->setCellValue('K5', 'V°B° Superior') 
                    ->setCellValue('L5', 'V°B° Rubro')
                    ->setCellValue('M5', 'Tipo de Moneda')
                    ->setCellValue('N5', 'Monto Aprox.');                                 

        //Configuración de tipos de letra                         
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:N5')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(true)        
                    ->getColor()
                    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
                    
        //fondo a celda
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:N5')
                    ->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('&H808080');         
        
        $solicitud = $this->mdl_exp_exc->mdl_csu_sol_pet($iCodSpt,
                                                        $iFemIni,
                                                        $iFemTer,
                                                        $iCodEss,
                                                        $iEmiPor,
                                                        $iSolPor,
                                                        $iCodSdp,
                                                        $iCodTsl,
                                                        $iCodNpr,
                                                        $iFetIni,
                                                        $iFetTer,
                                                        $iVboSup,
                                                        $iCodRbr,
                                                        $iVboRbr);

        $Ct = 5;
        
        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(false)        
                    ->getColor();   
           
        foreach ($solicitud as $sol)
        {
            $Ct = $Ct + 1;

            $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('B' . $Ct, $sol->tsp_cod_spt)
                            ->setCellValue('C' . $Ct, $sol->tes_des_ess)  
                            ->setCellValue('D' . $Ct, $sol->tsp_rzn_scl)                     
                            ->setCellValue('E' . $Ct, $sol->tsp_asu_sol)                      
                            ->setCellValue('F' . $Ct, $sol->mtx_fec_etm)                      
                            ->setCellValue('G' . $Ct, $sol->tsp_fec_emi)
                            ->setCellValue('H' . $Ct, $sol->tts_des_tsl)
                            ->setCellValue('I' . $Ct, $sol->tmp_emi_por)
                            ->setCellValue('J' . $Ct, $sol->tmp_sol_por)
                            ->setCellValue('K' . $Ct, $sol->tmp_vbo_sup)
                            ->setCellValue('L' . $Ct, $sol->tmp_vbo_rbr)
                            ->setCellValue('M' . $Ct, $sol->ttg_des_gnr)
                            ->setCellValue('N' . $Ct, $sol->tsp_mnt_inv);                                                     
                        
   
        $objPHPExcel->getActiveSheet()->getStyle('B' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER); 

        $objPHPExcel->getActiveSheet()->getStyle('F' . $Ct .':'.'G' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);       

        $objPHPExcel->getActiveSheet()->getStyle('M' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);  

        $objPHPExcel->getActiveSheet()->getStyle('N' . $Ct )->getNumberFormat()->setFormatCode('#,##0.00;[Red]-$#,##0.00'); 

        }   
                              
        $objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
        //Unir celdas 
        $objPHPExcel->getActiveSheet()->mergeCells('B2:D2');
             
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(10);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);         
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true); 
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);  
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);           
        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);             
        $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);             
        $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);             
        $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);             
                            
        $objPHPExcel->getActiveSheet()->setTitle('Exportacion');
        $objPHPExcel->setActiveSheetIndex(0);         
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Listado_de_Solicitudes.xls"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       
        
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');      
    } 

    Public Function fnc_exp_exc_rgt()
    {        
        /*[AUT-20190729 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                        
        
        /*[AUT-20190729 : Parametros de Entrada desde ExtJS]*/
        $iCodRgt = $data[0];
        $iFemIni = $data[1];
        $iFemTer = $data[2];
        $iCodFfj = $data[3];
        $iEstRgt = $data[4];
        $iEmiPor = $data[5];
        $iFegIni = $data[6];
        $iFegTer = $data[7];
        $iCodPrv = $data[8];
        $iCodTdo = $data[9];
        $iNumDoc = $data[10];
        $iCodIdd = $data[11];
        $iCodCgt = $data[12];
        $iCodCta = $data[13];
        $iAprGst = $data[14];

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);        
        
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion");                                      
        
        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado de Registro de Gastos');        
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B2')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(15)
                    ->setBold(true)
                    ->getColor();        
               
        /*Centrar Celdas*/            
        $objPHPExcel->getActiveSheet()->getStyle('B5:L5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('B5', 'N° Gasto')
                    ->setCellValue('C5', 'Fecha Emisión Gasto')
                    ->setCellValue('D5', 'Fecha de Ingreso')
                    ->setCellValue('E5', 'Emitido Por') 
                    ->setCellValue('F5', 'Categoría')
                    ->setCellValue('G5', 'Estado')
                    ->setCellValue('H5', 'Proveedor')  
                    ->setCellValue('I5', 'Empresa')                  
                    ->setCellValue('J5', 'Tipo de Documento') 
                    ->setCellValue('K5', 'Número de Documento')
                    ->setCellValue('L5', 'Monto Gasto');                                 

        //Configuración de tipos de letra                         
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:L5')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(true)        
                    ->getColor()
                    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
                    
        //fondo a celda
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:L5')
                    ->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('&H808080');         
        
        $gasto = $this->mdl_exp_exc->mdl_csu_reg_gst($iCodRgt,
                                                     $iFemIni,
                                                     $iFemTer,
                                                     $iCodFfj,
                                                     $iEstRgt,
                                                     $iEmiPor,
                                                     $iFegIni,
                                                     $iFegTer,
                                                     $iCodPrv,
                                                     $iCodTdo,
                                                     $iNumDoc,
                                                     $iCodIdd,
                                                     $iCodCgt,
                                                     $iCodCta,
                                                     $iAprGst);

         $Ct = 5;
        
        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(false)        
                    ->getColor();         
       
        foreach ($gasto as $gst)
        {
            $data_array[] = array('tmp_des_ffj' => $gst->tmp_des_ffj,
                                  'trg_cod_rgt' => $gst->trg_cod_rgt,
                                  'trg_fec_gst' => ($gst->trg_fec_gst <> '00/00/0000' ? $gst->trg_fec_gst : ''),
                                  'trg_fec_emi' => $gst->trg_fec_emi,
                                  'tmp_emi_por' => $gst->tmp_emi_por,
                                  'tcg_des_cgt' => $gst->tcg_des_cgt,
                                  'ter_des_rgt' => $gst->ter_des_rgt,
                                  'tmp_nom_prv' => $gst->tmp_nom_prv,
                                  'tsp_rzn_scl' => $gst->tsp_rzn_scl,
                                  'ttc_des_tdc' => $gst->ttc_des_tdc,
                                  'trg_num_doc' => $gst->trg_num_doc,
                                  'trg_mto_gst' => $gst->trg_mto_gst,
                                  'ter_bck_col' => $gst->ter_bck_col,
                                  'ter_tex_col' => $gst->ter_tex_col);          
        }   

        $group = groupArray($data_array,'tmp_des_ffj');       

        //Recorro todos los elementos
        for($i=0; $i < count($group); $i++)
        {             

            $Ct = $Ct + 2;

            /*tamaño letra en grilla*/
            $objPHPExcel->getActiveSheet()
                        ->getStyle('B' . $Ct)
                        ->getFont()
                        ->setBold(true)
                        ->setName('Calibri')
                        ->setSize(9); 

            
            $objPHPExcel->getActiveSheet()->mergeCells('B' . $Ct . ':L' . $Ct);

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('B' . $Ct, $group[$i]['tmp_des_ffj']);

            for($x=0; $x < count($group[$i]['groupeddata']); $x++)
            {             

                $Ct = $Ct + 1;

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('B' . $Ct, $group[$i]['groupeddata'][$x]['trg_cod_rgt'])
                            ->setCellValue('C' . $Ct, $group[$i]['groupeddata'][$x]['trg_fec_gst'])  
                            ->setCellValue('D' . $Ct, $group[$i]['groupeddata'][$x]['trg_fec_emi'])
                            ->setCellValue('E' . $Ct, $group[$i]['groupeddata'][$x]['tmp_emi_por'])
                            ->setCellValue('F' . $Ct, $group[$i]['groupeddata'][$x]['tcg_des_cgt'])                                    
                            ->setCellValue('G' . $Ct, $group[$i]['groupeddata'][$x]['ter_des_rgt'])
                            ->setCellValue('H' . $Ct, $group[$i]['groupeddata'][$x]['tmp_nom_prv'])
                            ->setCellValue('I' . $Ct, $group[$i]['groupeddata'][$x]['tsp_rzn_scl'])
                            ->setCellValue('J' . $Ct, $group[$i]['groupeddata'][$x]['ttc_des_tdc'])
                            ->setCellValue('K' . $Ct, $group[$i]['groupeddata'][$x]['trg_num_doc'])
                            ->setCellValue('L' . $Ct, $group[$i]['groupeddata'][$x]['trg_mto_gst']);                          

                $objPHPExcel->getActiveSheet()
                            ->getStyle('B' . $Ct .':'.'D' . $Ct)
                            ->getAlignment()
                            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);               

                $objPHPExcel->getActiveSheet()
                            ->getStyle('L' . $Ct)
                            ->getNumberFormat()
                            ->setFormatCode('#,##0.00;[Red]-$#,##0.00');

                $objPHPExcel->getActiveSheet()
                            ->getStyle('G' . $Ct)
                            ->getFont()
                            ->setName('Calibri')
                            ->setSize(8)
                            ->setBold(false)        
                            ->getColor()
                            ->setARGB( $group[$i]['groupeddata'][$x]['ter_tex_col']);

                $objPHPExcel->getActiveSheet()
                            ->getStyle('G' . $Ct)
                            ->getFill()
                            ->applyFromArray(array(
                                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                    'startcolor' => array(
                                                        'rgb' => $group[$i]['groupeddata'][$x]['ter_bck_col']
                                                    )
                                    ));                        

            } 
        }   
   
                              
        $objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);   

        //Unir celdas 
        $objPHPExcel->getActiveSheet()->mergeCells('B2:D2'); 

        $aColArr = array('C','D','E','F','G','H','I','J','K','L');
        
        foreach ($aColArr as $col) {
            # code...
            $objPHPExcel->getActiveSheet()->getColumnDimension($col)->setAutoSize(true);
        } 
        
        
                            
        $objPHPExcel->getActiveSheet()->setTitle('Exportacion');
        $objPHPExcel->setActiveSheetIndex(0);         
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Listado_de_Gastos.xls"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       
        
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');      
    }   

    Public Function fnc_exp_exc_rin()
    {        
        /*[AUT-20190804 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                        
        
        /*[AUT-20190804 : Parametros de Entrada desde ExtJS]*/
        $iCodRgs = $data[0];
        $iEstRgs = $data[1];
        $iFerIni = $data[2];
        $iFerTer = $data[3];
        $iEmiPor = $data[4];
        $iAprRgs = $data[5];
        $iCodFfj = $data[6];
        $iInfRgs = $data[7];

        $iInfRgs = str_replace("*", ".", $iInfRgs);
        $iInfRgs = str_replace("_", " ", $iInfRgs);         

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);        
        
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion");                                      
        
        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado de Rendición de Gastos');        
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B2')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(15)
                    ->setBold(true)
                    ->getColor();        
               
        /*Centrar Celdas*/            
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:F5')
                    ->getAlignment()
                    ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        

        $objPHPExcel->setActiveSheetIndex(0)                    
                    ->setCellValue('B5', 'N° Rendición')
                    ->setCellValue('C5', 'N° Gasto(s)')
                    ->setCellValue('D5', 'Empresa(s)')
                    ->setCellValue('E5', 'Emisor Rendición')
                    ->setCellValue('F5', 'Fecha Rendición')                    
                    ->setCellValue('G5', 'Estado Rendición')                     
                    ->setCellValue('H5', 'Total Gasto a Rendir');                               

        //Configuración de tipos de letra                         
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:H5')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(true)        
                    ->getColor()
                    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
                    
        //fondo a celda
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:H5')
                    ->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('&H808080');         
        
        $rendicion = $this->mdl_exp_exc->mdl_csu_rin_gst($iCodRgs,
                                                         $iEstRgs,
                                                         $iFerIni,
                                                         $iFerTer,
                                                         $iEmiPor,
                                                         $iAprRgs,
                                                         $iCodFfj,
                                                         $iInfRgs);

        $Ct = 5;
        
        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(false)        
                    ->getColor();         
       
        foreach ($rendicion as $rin)
        {
            $data_array[] = array('tmp_des_ffj' => $rin->tmp_des_ffj,                                  
                                  'trg_cod_rgs' => $rin->trg_cod_rgs,
                                  'trg_cod_rgt' => $rin->trg_cod_rgt,
                                  'tmp_rzn_scl' => $rin->tmp_rzn_scl,
                                  'tmp_emi_por' => $rin->tmp_emi_por,                                  
                                  'trg_fec_rgs' => ($rin->trg_fec_rgs <> '00/00/0000' ? $rin->trg_fec_rgs : ''),
                                  'ter_des_rgs' => $rin->ter_des_rgs,
                                  'trg_mto_rgs' => $rin->trg_mto_rgs,
                                  'ter_bck_col' => $rin->ter_bck_col,
                                  'ter_tex_col' => $rin->ter_tex_col);
        }   

        $group = groupArray($data_array,'tmp_des_ffj');       

        //Recorro todos los elementos
        for($i=0; $i < count($group); $i++)
        {             

            $Ct = $Ct + 2;

            /*tamaño letra en grilla*/
            $objPHPExcel->getActiveSheet()
                        ->getStyle('B' . $Ct)
                        ->getFont()
                        ->setBold(true)
                        ->setName('Calibri')
                        ->setSize(9); 

            
            $objPHPExcel->getActiveSheet()->mergeCells('B' . $Ct . ':D' . $Ct);

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('B' . $Ct, $group[$i]['tmp_des_ffj']);

            for($x=0; $x < count($group[$i]['groupeddata']); $x++)
            {             

                $Ct = $Ct + 1;

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('B' . $Ct, $group[$i]['groupeddata'][$x]['trg_cod_rgs'])
                            ->setCellValue('C' . $Ct, $group[$i]['groupeddata'][$x]['trg_cod_rgt'])  
                            ->setCellValue('D' . $Ct, $group[$i]['groupeddata'][$x]['tmp_rzn_scl'])
                            ->setCellValue('E' . $Ct, $group[$i]['groupeddata'][$x]['tmp_emi_por'])                                    
                            ->setCellValue('F' . $Ct, $group[$i]['groupeddata'][$x]['trg_fec_rgs'])
                            ->setCellValue('G' . $Ct, $group[$i]['groupeddata'][$x]['ter_des_rgs'])
                            ->setCellValue('H' . $Ct, $group[$i]['groupeddata'][$x]['trg_mto_rgs']);

                $objPHPExcel->getActiveSheet()
                            ->getStyle('B' . $Ct .':'.'C' . $Ct)
                            ->getAlignment()
                            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

                $objPHPExcel->getActiveSheet()
                            ->getStyle('F' . $Ct .':'.'G' . $Ct)
                            ->getAlignment()
                            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

                $objPHPExcel->getActiveSheet()
                            ->getStyle('H' . $Ct)
                            ->getNumberFormat()
                            ->setFormatCode('#,##0.00;[Red]-$#,##0.00');


                $objPHPExcel->getActiveSheet()
                            ->getStyle('G' . $Ct)
                            ->getFont()
                            ->setName('Calibri')
                            ->setSize(8)
                            ->setBold(false)        
                            ->getColor()
                            ->setARGB( $group[$i]['groupeddata'][$x]['ter_tex_col']);

                $objPHPExcel->getActiveSheet()
                            ->getStyle('G' . $Ct)
                            ->getFill()
                            ->applyFromArray(array(
                                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                    'startcolor' => array(
                                                        'rgb' => $group[$i]['groupeddata'][$x]['ter_bck_col']
                                                    )
                                    ));

            } 
        }   
   
                              
        $objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);   

        //Unir celdas 
        $objPHPExcel->getActiveSheet()->mergeCells('B2:D2'); 

        $aColArr = array('C','D','E','F','G','H','I');
        
        foreach ($aColArr as $col) {
            # code...
            $objPHPExcel->getActiveSheet()->getColumnDimension($col)->setAutoSize(true);
        }      
                                    
        $objPHPExcel->getActiveSheet()->setTitle('Exportacion');
        $objPHPExcel->setActiveSheetIndex(0);         
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Listado_de_Rendicion.xls"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       
        
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');      
    } 

    Public Function fnc_exp_exc_dps_plz()
    {        
        /*[AUT-20190822 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                        
        
        /*[AUT-20190822v : Parametros de Entrada desde ExtJS]*/
        $iCodDpz = $data[0];
        $iFemIni = $data[1];
        $iFemTer = $data[2];         
        $iEmiPor = $data[3];
        $iCodInv = $data[4];
        $iCodSdp = $data[5];
        $iAutPor = $data[6];        

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);        
        
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion");                                      
        
        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado de Depósito a Plazo');        
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B2')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(15)
                    ->setBold(true)
                    ->getColor();        
               
        /*Centrar Celdas*/            
        $objPHPExcel->getActiveSheet()->getStyle('B5:H5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('B5', 'N° Depósito')
                    ->setCellValue('C5', 'Empresa')
                    ->setCellValue('D5', 'Estado')                    
                    ->setCellValue('E5', 'Fecha Emisión')
                    ->setCellValue('F5', 'Emitido Por')                     
                    ->setCellValue('G5', 'Fecha Rescate')                              
                    ->setCellValue('H5', 'Monto Inversión');                              

        //Configuración de tipos de letra                         
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:H5')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(true)        
                    ->getColor()
                    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
                    
        //fondo a celda
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:H5')
                    ->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('&H808080');         
        
        $deposito = $this->mdl_exp_exc->mdl_csu_dps_pzo($iCodDpz,
                                                        ($iFemIni <> '' ?  $iFemIni . ' 00:00:00' : ''),
                                                        ($iFemTer <> '' ?  $iFemTer . ' 23:59:59' : ''),
                                                        $iEmiPor,
                                                        $iCodInv,
                                                        $iCodSdp,
                                                        $iAutPor);
        $Ct = 5;
        
        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(false)        
                    ->getColor();   
           
        foreach ($deposito as $dps)
        {
            $Ct = $Ct + 1;

            $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('B' . $Ct, $dps->tdp_cod_dpz)
                            ->setCellValue('C' . $Ct, $dps->tsp_rzn_scl)  
                            ->setCellValue('D' . $Ct, $dps->tei_des_inv)                      
                            ->setCellValue('E' . $Ct, ($dps->tdp_fec_emi <> '00/00/0000' ? $dps->tdp_fec_emi : ''))                    
                            ->setCellValue('F' . $Ct, $dps->tmp_emi_por)                                             
                            ->setCellValue('G' . $Ct, ($dps->tdp_fec_rsc <> '00/00/0000' ? $dps->tdp_fec_rsc : ''))                    
                            ->setCellValue('H' . $Ct, $dps->tdp_mnt_inv);

            $objPHPExcel->getActiveSheet()
                        ->getStyle('D' . $Ct)
                        ->getFont()
                        ->setName('Calibri')
                        ->setSize(8)
                        ->setBold(true)        
                        ->getColor()
                        ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);  

            $objPHPExcel->getActiveSheet()
                        ->getStyle('D' . $Ct)
                        ->getFill()
                        ->applyFromArray(array(
                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                'startcolor' => array(
                                                    'rgb' => $dps->tei_bck_col
                                                )
                                ));                                                                 

            $objPHPExcel->getActiveSheet()->getStyle('B' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);   
            $objPHPExcel->getActiveSheet()->getStyle('D' . $Ct .':'.'G' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);   

            $objPHPExcel->getActiveSheet()->getStyle('H' . $Ct )->getNumberFormat()->setFormatCode('#,##0;[Red]-$#,##0'); 

        }   
                              
        $objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
        //Unir celdas 
        $objPHPExcel->getActiveSheet()->mergeCells('B2:D2');
             
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(10);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);         
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true); 
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);        
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);        
                                    
        $objPHPExcel->getActiveSheet()->setTitle('Exportacion');
        $objPHPExcel->setActiveSheetIndex(0);         
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Listado_de_Deposito_a_Plazo.xls"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       
        
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');      
    }  

    Public Function fnc_exp_exc_sol_fmo()
    {        
        /*[AUT-20191001 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                        
        
        /*[AUT-20191001 : Parametros de Entrada desde ExtJS]*/
        $iCodFmo = $data[0];
        $iFemIni = $data[1];
        $iFemTer = $data[2];         
        $iEmiPor = $data[3];
        $iCodInv = $data[4];
        $iCodSdp = $data[5];
        $iAutPor = $data[6];        

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);        
        
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion");                                      
        
        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado de Fondo Mutuo');        
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B2')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(15)
                    ->setBold(true)
                    ->getColor();        
               
        /*Centrar Celdas*/            
        $objPHPExcel->getActiveSheet()->getStyle('B5:H5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('B5', 'N° Fondo Mutuo')
                    ->setCellValue('C5', 'Empresa')
                    ->setCellValue('D5', 'Estado')                    
                    ->setCellValue('E5', 'Fecha Emisión')
                    ->setCellValue('F5', 'Emitido Por')                     
                    ->setCellValue('G5', 'Fecha Rescate')                              
                    ->setCellValue('H5', 'Monto Inversión');                              

        //Configuración de tipos de letra                         
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:H5')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(true)        
                    ->getColor()
                    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
                    
        //fondo a celda
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:H5')
                    ->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('&H808080');         
        
        $fondo = $this->mdl_exp_exc->mdl_csu_sol_fmo($iCodFmo,
                                                    ($iFemIni <> '' ?  $iFemIni . ' 00:00:00' : ''),
                                                    ($iFemTer <> '' ?  $iFemTer . ' 23:59:59' : ''),
                                                    $iEmiPor,
                                                    $iCodInv,
                                                    $iCodSdp,
                                                    $iAutPor);
        $Ct = 5;
        
        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(false)        
                    ->getColor();   
           
        foreach ($fondo as $fmo)
        {
            $Ct = $Ct + 1;

            $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('B' . $Ct, $fmo->tsf_cod_fmo)
                            ->setCellValue('C' . $Ct, $fmo->tsp_rzn_scl)  
                            ->setCellValue('D' . $Ct, $fmo->tef_des_fmo)                             
                            ->setCellValue('E' . $Ct, ($fmo->tsf_fec_emi <> '00/00/0000' ? $fmo->tsf_fec_emi : ''))                    
                            ->setCellValue('F' . $Ct, $fmo->tmp_emi_por)                             
                            ->setCellValue('G' . $Ct, ($fmo->tsf_fec_rsc <> '00/00/0000' ? $fmo->tsf_fec_rsc : ''))                    
                            ->setCellValue('H' . $Ct, $fmo->tsf_mnt_inv);


            $objPHPExcel->getActiveSheet()
                        ->getStyle('D' . $Ct)
                        ->getFont()
                        ->setName('Calibri')
                        ->setSize(8)
                        ->setBold(true)        
                        ->getColor()
                        ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);  

            $objPHPExcel->getActiveSheet()
                        ->getStyle('D' . $Ct)
                        ->getFill()
                        ->applyFromArray(array(
                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                'startcolor' => array(
                                                    'rgb' => $fmo->tef_bck_col
                                                )
                                ));                                                                         

            $objPHPExcel->getActiveSheet()->getStyle('B' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);   
            $objPHPExcel->getActiveSheet()->getStyle('D' . $Ct .':'.'G' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);   

            $objPHPExcel->getActiveSheet()->getStyle('H' . $Ct )->getNumberFormat()->setFormatCode('#,##0;[Red]-$#,##0'); 

        }   
                              
        $objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
        //Unir celdas 
        $objPHPExcel->getActiveSheet()->mergeCells('B2:D2');
             
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(10);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);         
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true); 
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);        
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);        
                                    
        $objPHPExcel->getActiveSheet()->setTitle('Exportacion');
        $objPHPExcel->setActiveSheetIndex(0);         
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Listado_de_Fondo_Mutuo.xls"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       
        
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');      
    }  

    Public Function fnc_exp_exc_sol_fcr()
    {        
        /*[AUT-20201008 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                        
        
        /*[AUT-20191001 : Parametros de Entrada desde ExtJS]*/
        $iCodFcr = $data[0];
        $iFemIni = $data[1];
        $iFemTer = $data[2];  
        $iEstFcr = $data[3];
        $iCodSdp = $data[4];
        $iEmiPor = $data[5];
        $iCodPrv = $data[6];
        $iCodTis = $data[7];
        $iCodBse = $data[8];       

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);        
        
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion");                                      
        
        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado de Factoring');        
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B2')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(15)
                    ->setBold(true)
                    ->getColor();        
               
        /*Centrar Celdas*/            
        $objPHPExcel->getActiveSheet()->getStyle('B5:M5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('B5', 'N° Factoring')
                    ->setCellValue('C5', 'Estado')
                    ->setCellValue('D5', 'Empresa')
                    ->setCellValue('E5', 'Fecha Emisión')
                    ->setCellValue('F5', 'Fecha Inversión')
                    ->setCellValue('G5', 'Emitido Por')
                    ->setCellValue('H5', 'Cesionario')
                    ->setCellValue('I5', 'Institución')
                    ->setCellValue('J5', 'Tasa Base')
                    ->setCellValue('K5', 'Monto Inversión')               
                    ->setCellValue('L5', 'Valor Mercado')                              
                    ->setCellValue('M5', 'Valor Rescate');                 

        //Configuración de tipos de letra                         
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:M5')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(true)        
                    ->getColor()
                    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
                    
        //fondo a celda
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:M5')
                    ->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('&H808080');         
        
        $factoring = $this->mdl_exp_exc->mdl_csu_sol_fcr($iCodFcr,
                                                        ($iFemIni <> '' ?  $iFemIni . ' 00:00:00' : ''),
                                                        ($iFemTer <> '' ?  $iFemTer . ' 23:59:59' : ''),
                                                         $iEstFcr,
                                                         $iCodSdp,
                                                         $iEmiPor,
                                                         $iCodPrv,
                                                         $iCodTis,
                                                         $iCodBse);
        $Ct = 5;
        
        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(false)        
                    ->getColor();   
           
        foreach ($factoring as $fcr)
        {
            $Ct = $Ct + 1;

            $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('B' . $Ct, $fcr->tsf_cod_fcr)
                            ->setCellValue('C' . $Ct, $fcr->tef_des_fcr)  
                            ->setCellValue('D' . $Ct, $fcr->tsp_rzn_scl)                             
                            ->setCellValue('E' . $Ct, ($fcr->tsf_fec_emi <> '00/00/0000' ? $fcr->tsf_fec_emi : ''))                    
                            ->setCellValue('F' . $Ct, ($fcr->tsf_fec_inv <> '00/00/0000' ? $fcr->tsf_fec_inv : ''))                                                
                            ->setCellValue('G' . $Ct, $fcr->tmu_lgn_usr)
                            ->setCellValue('H' . $Ct, $fcr->tmp_nom_prv)
                            ->setCellValue('I' . $Ct, $fcr->tti_des_tis)
                            ->setCellValue('J' . $Ct, $fcr->tsf_tsa_bse)
                            ->setCellValue('K' . $Ct, $fcr->tsf_mnt_inv)
                            ->setCellValue('L' . $Ct, $fcr->tsf_val_mer)
                            ->setCellValue('M' . $Ct, $fcr->tsf_val_rsc);

            $objPHPExcel->getActiveSheet()
                        ->getStyle('C' . $Ct)
                        ->getFont()
                        ->setName('Calibri')
                        ->setSize(8)
                        ->setBold(true)        
                        ->getColor()
                        ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);  

            $objPHPExcel->getActiveSheet()
                        ->getStyle('C' . $Ct)
                        ->getFill()
                        ->applyFromArray(array(
                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                'startcolor' => array(
                                                    'rgb' => $fcr->tef_bck_col
                                                )
                                ));                                                                         
            
            $objPHPExcel->getActiveSheet()->getStyle('B' . $Ct .':'.'C' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);   
            $objPHPExcel->getActiveSheet()->getStyle('E' . $Ct .':'.'G' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);   

            $objPHPExcel->getActiveSheet()->getStyle('K' . $Ct .':'.'M' . $Ct )->getNumberFormat()->setFormatCode('$#,##0;[Red]-$#,##0'); 

        }   
                              
        $objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
        //Unir celdas 
        $objPHPExcel->getActiveSheet()->mergeCells('B2:D2');

        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(10);

        $aColArr = array('C','D','E','F','G','H','I','J','K','L','M');
        
        foreach ($aColArr as $col) {
            # code...
            $objPHPExcel->getActiveSheet()->getColumnDimension($col)->setAutoSize(true);
        }           
                                    
        $objPHPExcel->getActiveSheet()->setTitle('Exportacion');
        $objPHPExcel->setActiveSheetIndex(0);         
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Listado_de_factoring.xls"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       
        
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');      
    }  

    Public Function fnc_exp_exc_sol_fwd()
    {        
        /*[AUT-20190822 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                        
        
        /*[AUT-20190826 : Parametros de Entrada desde ExtJS]*/
        $iCodFwd = $data[0];
        $iFemIni = $data[1];
        $iFemTer = $data[2];
        $iCodSpt = $data[3];
        $iEstFwd = $data[4];
        $iEmiPor = $data[5];
        $iCodSdp = $data[6];
        $iCodTis = $data[7];
        $iAutPor = $data[8];   

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);        
        
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion");                                      
        
        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado de Forward');        
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B2')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(15)
                    ->setBold(true)
                    ->getColor();        
               
        /*Centrar Celdas*/            
        $objPHPExcel->getActiveSheet()->getStyle('B5:F5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('B5', 'N° Forward')
                    ->setCellValue('C5', 'Empresa')
                    ->setCellValue('D5', 'Estado')
                    ->setCellValue('E5', 'Fecha Emisión')
                    ->setCellValue('F5', 'Emitido Por');                    

        //Configuración de tipos de letra                         
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:F5')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(true)        
                    ->getColor()
                    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
                    
        //fondo a celda
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:F5')
                    ->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('&H808080');         
        
        $forward = $this->mdl_exp_exc->mdl_csu_sol_fwd($iCodFwd,
                                                        ($iFemIni <> '' ?  $iFemIni . ' 00:00:00' : ''),
                                                        ($iFemTer <> '' ?  $iFemTer . ' 23:59:59' : ''),
                                                        $iCodSpt,
                                                        $iEstFwd,
                                                        $iEmiPor,
                                                        $iCodSdp,
                                                        $iCodTis,
                                                        $iAutPor);

        $Ct = 5;
        
        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(false)        
                    ->getColor();   
           
        foreach ($forward as $fwd)
        {
            $Ct = $Ct + 1;

            $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('B' . $Ct, $fwd->tsf_cod_fwd)
                            ->setCellValue('C' . $Ct, $fwd->tsp_rzn_scl)  
                            ->setCellValue('D' . $Ct, $fwd->tef_des_fwd)
                            ->setCellValue('E' . $Ct, ($fwd->tsf_fec_emi <> '00/00/0000' ? $fwd->tsf_fec_emi : ''))                    
                            ->setCellValue('F' . $Ct, $fwd->tmp_emi_por);                            

            $objPHPExcel->getActiveSheet()
                        ->getStyle('D' . $Ct)
                        ->getFont()
                        ->setName('Calibri')
                        ->setSize(8)
                        ->setBold(true)        
                        ->getColor()
                        ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);  

            $objPHPExcel->getActiveSheet()
                        ->getStyle('D' . $Ct)
                        ->getFill()
                        ->applyFromArray(array(
                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                'startcolor' => array(
                                                    'rgb' => $fwd->tef_bck_col
                                                )
                                ));   

            $objPHPExcel->getActiveSheet()->getStyle('B' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);   
            $objPHPExcel->getActiveSheet()->getStyle('D' . $Ct .':'.'F' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);          

        }   
                              
        $objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
        //Unir celdas 
        $objPHPExcel->getActiveSheet()->mergeCells('B2:D2');
             
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(10);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);         
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true); 
                                            
        $objPHPExcel->getActiveSheet()->setTitle('Exportacion');
        $objPHPExcel->setActiveSheetIndex(0);         
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Listado_de_Forward.xls"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       
        
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');      
    }        
	
	
	Public Function fnc_exp_dcn_egi_BKPs()
    {        
        /*[AUT-20190514 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                        
        
        /*[AUT-20190514 : Parametros de Entrada desde ExtJS]*/
        $iOpcCol = $data[0];
        $iAnoMes = $data[1];
        $iCodFlj = $data[2];

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);        
        
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion");                                      
        
    	$csu_dcn_enc = $this->mdl_exp_exc->mdl_csu_dcn_egi($iOpcCol,$iAnoMes,$iCodFlj);
    	$csu_dcn_res = $this->mdl_exp_exc->mdl_csu_dcn_egi(2,$iAnoMes,$iCodFlj);
	

        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Desicion Estrategica '.date("d/m/Y"));        
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B2')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(15)
                    ->setBold(true)
                    ->getColor();     


    	$Ec = 0;
    	$D = '';$E = '';$F = '';$G = '';$H = '';$I = '';$J = '';$K = '';$L = '';$M = '';
    	$N = '';$O = '';$P = '';$Q = '';$R = '';$S = '';$T = '';$U = '';$V = '';$W = '';$X = '';
    	foreach ($csu_dcn_enc as $enc)
        {
	        $Ec = $Ec + 1;
		
    		if($Ec === 1)    {$D= $enc->tmp_ano_row;}
    	    elseif($Ec === 2){$E= $enc->tmp_ano_row;} 
    		elseif($Ec === 3){$F= $enc->tmp_ano_row;} 
    		elseif($Ec === 4){$G= $enc->tmp_ano_row;} 
    		elseif($Ec === 5){$H= $enc->tmp_ano_row;} 
    		elseif($Ec === 6){$I= $enc->tmp_ano_row;} 
    		elseif($Ec === 7){$J= $enc->tmp_ano_row;} 
    		elseif($Ec === 8){$K= $enc->tmp_ano_row;} 
    		elseif($Ec === 9){$L= $enc->tmp_ano_row;} 
    		elseif($Ec === 10){$M= $enc->tmp_ano_row;} 
    		elseif($Ec === 11){$N= $enc->tmp_ano_row;} 
    		elseif($Ec === 12){$O= $enc->tmp_ano_row;}
    		elseif($Ec === 13){$P= $enc->tmp_ano_row;}	
    		elseif($Ec === 14){$Q= $enc->tmp_ano_row;}
    		elseif($Ec === 15){$R= $enc->tmp_ano_row;}
    		elseif($Ec === 16){$S= $enc->tmp_ano_row;}
    		elseif($Ec === 17){$T= $enc->tmp_ano_row;}
    		elseif($Ec === 18){$U= $enc->tmp_ano_row;}
    		elseif($Ec === 19){$V= $enc->tmp_ano_row;}
    		elseif($Ec === 20){$W= $enc->tmp_ano_row;}
    		elseif($Ec === 21){$X= $enc->tmp_ano_row;}

        }
	
        /*Centrar Celdas*/            
        $objPHPExcel->getActiveSheet()->getStyle('B5:X5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
        $objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('B5', 'Tipo')
                    ->setCellValue('C5', 'Flujo')
                    ->setCellValue('D5', $D)
                    ->setCellValue('E5', $E)
                    ->setCellValue('F5', $F)
                    ->setCellValue('G5', $G)
                    ->setCellValue('H5', $H)
                    ->setCellValue('I5', $I)
                    ->setCellValue('J5', $J)
					->setCellValue('K5', $K)
					->setCellValue('L5', $L)
					->setCellValue('M5', $M)
					->setCellValue('N5', $N)
					->setCellValue('O5', $O)
					->setCellValue('P5', $P)
					->setCellValue('Q5', $Q)
					->setCellValue('R5', $R)
					->setCellValue('S5', $S)
					->setCellValue('T5', $T)
					->setCellValue('U5', $U)
					->setCellValue('V5', $V)
					->setCellValue('W5', $W)
					->setCellValue('X5', $X);                    

        //Configuración de tipos de letra                         
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:X5')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(true)        
                    ->getColor()
                    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
                    
        //fondo a celda
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:X5')
                    ->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('&H808080');         

        $Ct = 5;
        
        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(false)        
                    ->getColor();   
           
        foreach ($csu_dcn_res as $res)
        {
	        $Ct = $Ct + 1;

	        $objPHPExcel->setActiveSheetIndex(0)
							->setCellValue('B' . $Ct, $res->tmp_tip_cta)
	                        ->setCellValue('C' . $Ct, $res->tae_des_aeg)
							->setCellValue('D' . $Ct, $res->tmp_fec_001)                           
	                        ->setCellValue('E' . $Ct, $res->tmp_fec_002)                      
							->setCellValue('F' . $Ct, $res->tmp_fec_003)                      
	                        ->setCellValue('G' . $Ct, $res->tmp_fec_004)                      
	                        ->setCellValue('H' . $Ct, $res->tmp_fec_005)
	                        ->setCellValue('I' . $Ct, $res->tmp_fec_006)
	                        ->setCellValue('J' . $Ct, $res->tmp_fec_007)
							->setCellValue('K' . $Ct, $res->tmp_fec_008)
							->setCellValue('L' . $Ct, $res->tmp_fec_009)
							->setCellValue('M' . $Ct, $res->tmp_fec_010)
							->setCellValue('N' . $Ct, $res->tmp_fec_011)
							->setCellValue('O' . $Ct, $res->tmp_fec_012)
							->setCellValue('P' . $Ct, $res->tmp_fec_013)
							->setCellValue('Q' . $Ct, $res->tmp_fec_014)
							->setCellValue('R' . $Ct, $res->tmp_fec_015)
							->setCellValue('S' . $Ct, $res->tmp_fec_016)
							->setCellValue('T' . $Ct, $res->tmp_fec_017)
							->setCellValue('U' . $Ct, $res->tmp_fec_018)
							->setCellValue('V' . $Ct, $res->tmp_fec_019)
							->setCellValue('W' . $Ct, $res->tmp_fec_020)
							->setCellValue('X' . $Ct, $res->tmp_fec_021);                                         
                        
        /*Centrar Celdas*/                
        $objPHPExcel->getActiveSheet()->getStyle('D' . $Ct . ':X' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);         

		$objPHPExcel->getActiveSheet()->getStyle('D' . $Ct . ':X' . $Ct )->getNumberFormat()->setFormatCode('$#,##0.00;[Red]-$#,##0.00');

        }   
                              
        $objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
        //Unir celdas 
        $objPHPExcel->getActiveSheet()->mergeCells('B2:X2');
             
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);         
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true); 
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);    
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('R')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('S')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('T')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('U')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('V')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('W')->setAutoSize(true);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('X')->setAutoSize(true);	
             
        $objPHPExcel->getActiveSheet()->setTitle('Exportacion');
        $objPHPExcel->setActiveSheetIndex(0);         
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Decision Estrategica "'.date("d/m/Y").'".xls"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       
        
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');      
    }


    Public Function fnc_exp_exl_trb()
    { 
        /*[AUT-20200108 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                        
        
        /*[AUT-20190514 : Parametros de Entrada desde ExtJS]*/
        $iCodTrb = $data[0];
        $iCodEst = $data[1];
        $iRutTrb = $data[2];
        $iNomTrb = $data[3];
        $iApeTrb = $data[4];
        $iCgoTrb = $data[5];
        $iCodCco = $data[6];
        $iCodEmp = $data[7];    

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set("memory_limit", "-1");
        set_time_limit(0);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);        
        
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion");                                   
        
        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado de Colaboradores');        
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B2')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(15)
                    ->setBold(true)
                    ->getColor();        
               
        /*Centrar Celdas*/            
        $objPHPExcel->getActiveSheet()->getStyle('B5:O5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('B5', 'Código')
                    ->setCellValue('C5', utf8_encode('Estado'))
                    ->setCellValue('D5', utf8_encode('Empresa'))
                    ->setCellValue('E5', 'RUT')
                    ->setCellValue('F5', 'Nombre Apellido')                    
                    ->setCellValue('G5', utf8_encode('Nacionalidad'))    
                    ->setCellValue('H5', utf8_encode('Estado Civil'))  
                    ->setCellValue('I5', utf8_encode('Fecha Nacimiento'))  
                    ->setCellValue('J5', 'Dirección')  
                    ->setCellValue('K5', utf8_encode('Comuna'))  
                    ->setCellValue('L5', 'Teléfono Fijo')  
                    ->setCellValue('M5', utf8_encode('Celular'))  
                    ->setCellValue('N5', utf8_encode('E-Mail'))  
                    ->setCellValue('O5', utf8_encode('Cargo'));                                 
                           
        //Configuración de tipos de letra                         
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:O5')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(true)        
                    ->getColor()
                    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
                    
        //fondo a celda
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:O5')
                    ->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('&H808080');         
        
        $trabajador = $this->mdl_exp_exc->mdl_csu_mae_trb($iCodTrb,
                                                          $iCodEst,
                                                          $iRutTrb,
                                                          $iNomTrb,
                                                          $iApeTrb,
                                                          $iCgoTrb,
                                                          $iCodCco,
                                                          $iCodEmp);        
        
        $Ct = 5;
        
        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(false)        
                    ->getColor();   
           
        foreach ($trabajador as $row)
        {
            $Ct = $Ct + 1;

            $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('B' . $Ct, $row->tmt_cod_trb)
                            ->setCellValue('C' . $Ct, $row->tet_des_est)
                            ->setCellValue('D' . $Ct, $row->tsp_rzn_scl)
                            ->setCellValue('E' . $Ct, $row->tmt_rut_trb . '-' . $row->tmt_dig_trb)
                            ->setCellValue('F' . $Ct, $row->tmt_nom_trb . ' ' . $row->tmt_ape_trb)                            
                            ->setCellValue('G' . $Ct, $row->tmt_nac_trb)
                            ->setCellValue('H' . $Ct, $row->tec_des_civ)
                            ->setCellValue('I' . $Ct, fcf_cmb_fec($row->tmt_fec_nac))
                            ->setCellValue('J' . $Ct, $row->tmt_dir_trb)
                            ->setCellValue('K' . $Ct, $row->tmc_des_com)
                            ->setCellValue('L' . $Ct, $row->tmt_tel_trb)
                            ->setCellValue('M' . $Ct, $row->tmt_cel_trb)
                            ->setCellValue('N' . $Ct, $row->tmt_eml_trb)
                            ->setCellValue('O' . $Ct, $row->tct_des_trb);


            $objPHPExcel->getActiveSheet()
                        ->getStyle('C' . $Ct)
                        ->getFont()
                        ->setName('Calibri')
                        ->setSize(8)
                        ->setBold(true)        
                        ->getColor()
                        ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);  

            $objPHPExcel->getActiveSheet()
                        ->getStyle('C' . $Ct)
                        ->getFill()
                        ->applyFromArray(array(
                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                'startcolor' => array(
                                                    'rgb' => $row->tet_bck_col
                                                )
                                ));
                            
            /*Centrar Celdas*/        
            $objPHPExcel->getActiveSheet()->getStyle('B' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);  
            $objPHPExcel->getActiveSheet()->getStyle('C' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);  
            $objPHPExcel->getActiveSheet()->getStyle('G' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);  
        }  
                              
        $objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
        //Unir celdas 
        $objPHPExcel->getActiveSheet()->mergeCells('B2:D2');
             
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(7);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);         
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true); 
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true); 
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true); 
        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);           
        $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);           
        $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);           
        $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);
                    
        $objPHPExcel->getActiveSheet()->setTitle('Exportacion');
        $objPHPExcel->setActiveSheetIndex(0);         
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Listado_de_Colaboradoress.xls"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       
        
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');     
    }

    Public Function fnc_exp_exc_itz_rin_gst()
    { 
        /*[AUT-20200129 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                        
        
        /*[AUT-20200129 : Parametros de Entrada desde ExtJS]*/
        $iTipOpe = 2;
        $iCodIdd = $data[0];
        $iCodRgt = '0';        
        $iCodFfj = 0;    

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set("memory_limit", "-1");
        set_time_limit(0);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);        
        
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion");                                   
                        
        //Pintado del encabezado -----
        fnc_ret_enc_itz($objPHPExcel);
        //----------------------------   
        
        $Ct = 1;

        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Arial')
                    ->setSize(10)
                    ->setBold(false)        
                    ->getColor();  

        $rendicion = $this->mdl_exp_exc->mdl_csu_rin_reg_gst($iTipOpe,
                                                             $iCodIdd,
                                                             $iCodRgt,
                                                             $iCodFfj);    
           
        foreach ($rendicion as $row)
        {
            $Ct = $Ct + 1;

            if($row->cod_emp_gst !== $row->cod_emp_ffj){

                $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('A' . $Ct, $row->tpc_cta_ctb_mer)                            
                                ->setCellValue('B' . $Ct, $row->trg_mto_gst)
                                ->setCellValue('D' . $Ct, 'GASTO - ' . $row->ttc_des_tdc);   

            }else{

                $aPlaCtaSep = explode("-",$row->tpc_cta_ctb);            

                switch (substr($row->tpc_cta_ctb,0,8)) {
                    //Cta. Contable ??????
                    /*case '1-11-45-': 
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('A' . $Ct, $row->tpc_cta_ctb)                            
                                    ->setCellValue('B' . $Ct, $row->trg_mto_gst)
                                    ->setCellValue('D' . $Ct, 'GASTO - ' . $row->ttc_des_tdc);                                
                        break;*/

                    case '4-19-30-': //Cta. Contable Tipo de Gasto
                        if ($row->tmc_cod_cco <> '99'){
                            $aDesCcoSep = explode("-",$row->tmc_des_cco); 
                            $iDesCco = $aDesCcoSep[0] . '-' . $aDesCcoSep[1] . '-' . $aDesCcoSep[2];   
                        }else{
                            $iDesCco = $row->tmc_des_cco;
                        }                    

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('A' . $Ct, $row->tpc_cta_ctb)                            
                                    ->setCellValue('B' . $Ct, $row->trg_mto_gst)
                                    ->setCellValue('D' . $Ct, 'GASTO - ' . $row->ttc_des_tdc)
                                    ->setCellValue('P' . $Ct, $iDesCco);
                        break;

                    case '2-15-40-': //Cta. Contable Honorarios
                        if($aPlaCtaSep[3] === '140'){
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('A' . $Ct, $row->tpc_cta_ctb)                            
                                        ->setCellValue('B' . $Ct, $row->trg_mto_gst)
                                        ->setCellValue('D' . $Ct, 'GASTO - ' . $row->ttc_des_tdc)
                                        ->setCellValue('S' . $Ct, $row->tmp_rut_prv)
                                        ->setCellValue('T' . $Ct, 'TR')
                                        ->setCellValue('U' . $Ct, $row->trg_num_doc)
                                        ->setCellValue('V' . $Ct, str_replace("/", "-", $row->mtx_fec_gst))
                                        ->setCellValue('W' . $Ct, str_replace("/", "-", $row->mtx_fec_gst))
                                        ->setCellValue('X' . $Ct, 'H3')
                                        ->setCellValue('Y' . $Ct, $row->trg_num_doc);
                        }
                        
                        break;

                    case '2-15-30-': //Cta. Contable Proveedor
                        if($aPlaCtaSep[3] === '110'){

                            if($row->ttc_cod_tdc === '100'){ // FACTURA AFECTA

                                $objPHPExcel->setActiveSheetIndex(0)
                                            ->setCellValue('A' . $Ct, $row->tpc_cta_ctb)                            
                                            ->setCellValue('B' . $Ct, $row->trg_mto_gst)
                                            ->setCellValue('D' . $Ct, 'GASTO - ' . $row->ttc_des_tdc)
                                            ->setCellValue('S' . $Ct, $row->tmp_rut_prv)
                                            ->setCellValue('T' . $Ct, 'TR')
                                            ->setCellValue('U' . $Ct, $row->trg_num_doc)
                                            ->setCellValue('V' . $Ct, str_replace("/", "-", $row->mtx_fec_gst))
                                            ->setCellValue('W' . $Ct, str_replace("/", "-", $row->mtx_fec_gst))
                                            ->setCellValue('X' . $Ct, 'C3')
                                            ->setCellValue('Y' . $Ct, $row->trg_num_doc);
                            }

                            if($row->ttc_cod_tdc === '101'){ // FACTURA EXENTA

                                $objPHPExcel->setActiveSheetIndex(0)
                                            ->setCellValue('A' . $Ct, $row->tpc_cta_ctb)                            
                                            ->setCellValue('B' . $Ct, $row->trg_mto_gst)
                                            ->setCellValue('D' . $Ct, 'GASTO - ' . $row->ttc_des_tdc)
                                            ->setCellValue('S' . $Ct, $row->tmp_rut_prv)
                                            ->setCellValue('T' . $Ct, 'TR')
                                            ->setCellValue('U' . $Ct, $row->trg_num_doc)
                                            ->setCellValue('V' . $Ct, str_replace("/", "-", $row->mtx_fec_gst))
                                            ->setCellValue('W' . $Ct, str_replace("/", "-", $row->mtx_fec_gst))
                                            ->setCellValue('X' . $Ct, 'C4')
                                            ->setCellValue('Y' . $Ct, $row->trg_num_doc);
                            }
                        }
                        
                        break;
                    
                    default:
                        # code...
                            $objPHPExcel->setActiveSheetIndex(0)
                                            ->setCellValue('A' . $Ct, 'CODIGO SIN INTERFAZ');  
                        break;
                }
            }         
        }    

        //********************************************************************************************
        $rendicionFin = $this->mdl_exp_exc->mdl_csu_rin_gst($iCodIdd,
                                                             0,
                                                             '',
                                                             '',
                                                             0,
                                                             0,
                                                             0,
                                                             '');
        foreach ($rendicionFin as $rin) {   

            $Ct = $Ct + 1;         

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A' . $Ct, '1-11-10-125')                            
                        ->setCellValue('C' . $Ct, $rin->trg_mto_rgs)
                        ->setCellValue('D' . $Ct, 'RENDICION ' . $rin->tmp_emi_por)
                        ->setCellValue('S' . $Ct, $rin->tff_rut_ffj)
                        ->setCellValue('T' . $Ct, 'TR')
                        ->setCellValue('U' . $Ct, str_replace("-", "", $rin->trg_ped_ctb))
                        ->setCellValue('V' . $Ct, str_replace("/", "-", $rin->trg_fec_rgs))
                        ->setCellValue('W' . $Ct, str_replace("/", "-", $rin->trg_fec_rgs))
                        ->setCellValue('X' . $Ct, 'TR')
                        ->setCellValue('Y' . $Ct, str_replace("-", "", $rin->trg_ped_ctb));       
        }
        //********************************************************************************************
                    
        $objPHPExcel->getActiveSheet()->setTitle('Exportacion');
        $objPHPExcel->setActiveSheetIndex(0);       

        $aColArr = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','AA','AB','AC','AD','AE','AF','AG','AH','AI','AJ','AK','AL','AM','AN','AO','AP','AQ','AR','AS','AT','AU','AV','AW','AX','AY','AZ','BA','BB','BC','BD','BE','BF');
        
        foreach ($aColArr as $col) {
            # code...
            $objPHPExcel->getActiveSheet()->getColumnDimension($col)->setAutoSize(true);
        }       
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="IterfazRinGastosDelFondo.csv"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       
        
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');     
    }

    Public Function fnc_exp_exc_itz_rin_emp_rel()
    { 
        /*[AUT-20210302 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                        
        
        /*[AUT-20210302 : Parametros de Entrada desde ExtJS]*/
        $iCodRgs = $data[0];
        $iCodSdp = $data[1];    

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set("memory_limit", "-1");
        set_time_limit(0);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);  

        $this->load->model('mdl_det_pry');     
        
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion");                                   
                        
        //Pintado del encabezado -----
        fnc_ret_enc_itz($objPHPExcel);
        //----------------------------   
        
        $Ct = 1;

        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Arial')
                    ->setSize(10)
                    ->setBold(false)        
                    ->getColor();  

        $interfaz = $this->mdl_exp_exc->mdl_csu_itz_rin_emp_rel($iCodRgs,$iCodSdp); 

        $iMtoRgs = 0;  
           
        foreach ($interfaz as $row)
        {
            $Ct = $Ct + 1;

            $aPlaCtaSep = explode("-",$row->tpc_cta_ctb);            

            switch (substr($row->tpc_cta_ctb,0,8)) {
                case '1-11-45-': //Cta. Contable ??????
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('A' . $Ct, $row->tpc_cta_ctb)                            
                                ->setCellValue('B' . $Ct, $row->trg_mto_gst)
                                ->setCellValue('D' . $Ct, 'GASTO - ' . $row->ttc_des_tdc); 

                    //Grabar Gastos por pagar en sociedad----------------------------------
                    $this->mdl_det_pry->mdl_grb_gst_xpg(-1,100,$iCodSdp,$row->trg_cod_rgt);
                    //--------------------------------------------------------------------- 

                    break;

                case '4-19-30-': //Cta. Contable Tipo de Gasto
                    if ($row->tmc_cod_cco <> '99'){
                        $aDesCcoSep = explode("-",$row->tmc_des_cco); 
                        $iDesCco = $aDesCcoSep[0] . '-' . $aDesCcoSep[1] . '-' . $aDesCcoSep[2];   
                    }else{
                        $iDesCco = $row->tmc_des_cco;
                    }                    

                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('A' . $Ct, $row->tpc_cta_ctb)                            
                                ->setCellValue('B' . $Ct, $row->trg_mto_gst)
                                ->setCellValue('D' . $Ct, 'GASTO - ' . $row->ttc_des_tdc)
                                ->setCellValue('P' . $Ct, $iDesCco);

                    //Grabar Gastos por pagar en sociedad----------------------------------
                    $this->mdl_det_pry->mdl_grb_gst_xpg(-1,100,$iCodSdp,$row->trg_cod_rgt);
                    //--------------------------------------------------------------------- 

                    break;

                case '2-15-40-': //Cta. Contable Honorarios
                    if($aPlaCtaSep[3] === '140'){
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('A' . $Ct, $row->tpc_cta_ctb)                            
                                    ->setCellValue('B' . $Ct, $row->trg_mto_gst)
                                    ->setCellValue('D' . $Ct, 'GASTO - ' . $row->ttc_des_tdc)
                                    ->setCellValue('S' . $Ct, $row->tmp_rut_prv)
                                    ->setCellValue('T' . $Ct, 'TR')
                                    ->setCellValue('U' . $Ct, $row->trg_num_doc)
                                    ->setCellValue('V' . $Ct, str_replace("/", "-", $row->mtx_fec_gst))
                                    ->setCellValue('W' . $Ct, str_replace("/", "-", $row->mtx_fec_gst))
                                    ->setCellValue('X' . $Ct, 'H3')
                                    ->setCellValue('Y' . $Ct, $row->trg_num_doc);
                    }

                    //Grabar Gastos por pagar en sociedad----------------------------------
                    $this->mdl_det_pry->mdl_grb_gst_xpg(-1,100,$iCodSdp,$row->trg_cod_rgt);
                    //--------------------------------------------------------------------- 
                    
                    break;

                case '2-15-30-': //Cta. Contable Proveedor
                    if($aPlaCtaSep[3] === '110'){

                        if($row->ttc_cod_tdc === '100'){ // FACTURA AFECTA

                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('A' . $Ct, $row->tpc_cta_ctb)                            
                                        ->setCellValue('B' . $Ct, $row->trg_mto_gst)
                                        ->setCellValue('D' . $Ct, 'GASTO - ' . $row->ttc_des_tdc)
                                        ->setCellValue('S' . $Ct, $row->tmp_rut_prv)
                                        ->setCellValue('T' . $Ct, 'TR')
                                        ->setCellValue('U' . $Ct, $row->trg_num_doc)
                                        ->setCellValue('V' . $Ct, str_replace("/", "-", $row->mtx_fec_gst))
                                        ->setCellValue('W' . $Ct, str_replace("/", "-", $row->mtx_fec_gst))
                                        ->setCellValue('X' . $Ct, 'C3')
                                        ->setCellValue('Y' . $Ct, $row->trg_num_doc);

                            //Grabar Gastos por pagar en sociedad----------------------------------
                            $this->mdl_det_pry->mdl_grb_gst_xpg(-1,100,$iCodSdp,$row->trg_cod_rgt);
                            //--------------------------------------------------------------------- 
                        }

                        if($row->ttc_cod_tdc === '101'){ // FACTURA EXENTA

                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('A' . $Ct, $row->tpc_cta_ctb)                            
                                        ->setCellValue('B' . $Ct, $row->trg_mto_gst)
                                        ->setCellValue('D' . $Ct, 'GASTO - ' . $row->ttc_des_tdc)
                                        ->setCellValue('S' . $Ct, $row->tmp_rut_prv)
                                        ->setCellValue('T' . $Ct, 'TR')
                                        ->setCellValue('U' . $Ct, $row->trg_num_doc)
                                        ->setCellValue('V' . $Ct, str_replace("/", "-", $row->mtx_fec_gst))
                                        ->setCellValue('W' . $Ct, str_replace("/", "-", $row->mtx_fec_gst))
                                        ->setCellValue('X' . $Ct, 'C4')
                                        ->setCellValue('Y' . $Ct, $row->trg_num_doc);

                            //Grabar Gastos por pagar en sociedad----------------------------------
                            $this->mdl_det_pry->mdl_grb_gst_xpg(-1,100,$iCodSdp,$row->trg_cod_rgt);
                            //--------------------------------------------------------------------- 
                        }
                    }
                    
                    break;
                
                default:
                    # code...
                        $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('A' . $Ct, 'CODIGO SIN INTERFAZ');  
                    break;
            } 


            //$iMtoRgs+= $row->trg_mto_gst;         
            $iMtoRgs = $iMtoRgs + $row->trg_mto_gst;

        }    

        //********************************************************************************************
        $rendicionFin = $this->mdl_exp_exc->mdl_csu_rin_gst($iCodRgs,
                                                             0,
                                                             '',
                                                             '',
                                                             0,
                                                             0,
                                                             0,
                                                             '');
        foreach ($rendicionFin as $rin) {                        

            $Ct = $Ct + 1;

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A' . $Ct, $row->tpc_cta_ctb_mer_ffj)                            
                        ->setCellValue('C' . $Ct, $iMtoRgs)
                        ->setCellValue('D' . $Ct, 'RENDICION ' . $rin->tmp_emi_por)
                        ->setCellValue('S' . $Ct, $rin->tff_rut_ffj)
                        ->setCellValue('T' . $Ct, 'TR')
                        ->setCellValue('U' . $Ct, str_replace("-", "", $rin->trg_ped_ctb))
                        ->setCellValue('V' . $Ct, str_replace("/", "-", $rin->trg_fec_rgs))
                        ->setCellValue('W' . $Ct, str_replace("/", "-", $rin->trg_fec_rgs))
                        ->setCellValue('X' . $Ct, 'TR')
                        ->setCellValue('Y' . $Ct, str_replace("-", "", $rin->trg_ped_ctb));       
        }
        //********************************************************************************************
                    
        $objPHPExcel->getActiveSheet()->setTitle('Exportacion');
        $objPHPExcel->setActiveSheetIndex(0);       

        $aColArr = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','AA','AB','AC','AD','AE','AF','AG','AH','AI','AJ','AK','AL','AM','AN','AO','AP','AQ','AR','AS','AT','AU','AV','AW','AX','AY','AZ','BA','BB','BC','BD','BE','BF');
        
        foreach ($aColArr as $col) {
            # code...
            $objPHPExcel->getActiveSheet()->getColumnDimension($col)->setAutoSize(true);
        }       
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="IterfazRinGastosEmpRel.csv"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       
        
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');     
    }

    Public Function fnc_exp_exc_itz_flj_dia()
    {
        /*[AUT-20210316 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                        
        
        /*[AUT-20210316 : Parametros de Entrada desde ExtJS]*/
        $iFecFlj = $data[0];
        $iCodSdp = $data[1];    

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set("memory_limit", "-1");
        set_time_limit(0);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE); 
                
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion"); 

        //Pintado del encabezado -----
        fnc_ret_enc_itz($objPHPExcel);
        //----------------------------
        
        $Ct = 1;

        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(false)        
                    ->getColor();  

        $interfaz = $this->mdl_exp_exc->mdl_csu_itz_flj_dia($iFecFlj,$iCodSdp);          
           
        foreach ($interfaz as $row)
        {
            $Ct = $Ct + 1;       

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A' . $Ct, $row->tmp_cta_ctb)                            
                        ->setCellValue('B' . $Ct, number_format((int)$row->tmp_mto_ing, 0,'',''))
                        ->setCellValue('C' . $Ct, number_format((int)$row->tmp_mto_egr, 0,'',''))
                        ->setCellValue('D' . $Ct, $row->tmp_des_mvt)  
                        ->setCellValue('P' . $Ct, $row->tmp_cco_cos)
                        ->setCellValue('Q' . $Ct, $row->tmp_doc_cnl)
                        ->setCellValue('R' . $Ct, $row->tmp_num_cnl)
                        ->setCellValue('S' . $Ct, $row->tmp_rut_aux)
                        ->setCellValue('T' . $Ct, $row->tmp_tip_doc)
                        ->setCellValue('U' . $Ct, $row->tmp_num_doc)
                        ->setCellValue('V' . $Ct, $row->tmp_fec_emi)
                        ->setCellValue('W' . $Ct, $row->tmp_fec_vto)
                        ->setCellValue('X' . $Ct, $row->tmp_tdc_ref)
                        ->setCellValue('Y' . $Ct, $row->tmp_num_ref);
        }
        //********************************************************************************************
                    
        $objPHPExcel->getActiveSheet()->setTitle($row->tmp_nom_fan);
        $objPHPExcel->setActiveSheetIndex(0);               
        
        $aColArr = array('A','B','C','D','Q','R','S','T','U','V','W','X','Y','Z');

        foreach ($aColArr as $col) {
            # code...
            $objPHPExcel->getActiveSheet()->getColumnDimension($col)->setWidth(15);
        }       
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="ItzFljDia' . $row->tmp_nom_fan . '.csv"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       
        
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');     
    }

    Public Function fnc_exp_exc_itz_flj_dia_BKPs()
    {
        /*[AUT-20210316 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                        
        
        /*[AUT-20210316 : Parametros de Entrada desde ExtJS]*/
        $iFecFlj = $data[0];
        $iCodSdp = $data[1];    

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set("memory_limit", "-1");
        set_time_limit(0);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE); 
                
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion"); 

        //Pintado del encabezado -----
        fnc_ret_enc_itz($objPHPExcel);
        //----------------------------
        
        $Ct = 1;

        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(false)        
                    ->getColor();  

        $interfaz = $this->mdl_exp_exc->mdl_csu_itz_flj_dia($iFecFlj,$iCodSdp);          
           
        foreach ($interfaz as $row)
        {
            $Ct = $Ct + 1;             

            if ((int)$row->trf_tip_cta === 1){ //INGRESO 

                //---------------------------------------------------------------------------------------------------
                if($row->cta_mer_pry === '100'){ // contra parte no es cuenta mercatil

                    if($row->tmc_cod_cco === '0'){ // Si Código Centro de costo = 0 pinta valores tengo dudas ????????

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('A' . $Ct, $row->cta_ctb_pry)                            
                                    ->setCellValue('C' . $Ct, number_format((int)$row->tdp_mto_pso, 0,'',''))
                                    ->setCellValue('D' . $Ct, $row->nom_cta_pry)                                
                                    ->setCellValue('S' . $Ct, $row->tmp_rut_aux)
                                    ->setCellValue('T' . $Ct, $row->abr_tdc_pry)
                                    ->setCellValue('U' . $Ct, $row->tdp_num_doc)
                                    ->setCellValue('V' . $Ct, $row->tdp_fec_mvt)
                                    ->setCellValue('W' . $Ct, $row->tdp_fec_mvt)
                                    ->setCellValue('X' . $Ct, $row->abr_tdc_ref)
                                    ->setCellValue('Y' . $Ct, $row->tdp_num_ref);                                               
                    }else{
                         
                        $aDesCcoSep = explode("-",$row->tmc_des_cco); 
                        $iDesCco = $aDesCcoSep[0] . '-' . $aDesCcoSep[1] . '-' . $aDesCcoSep[2];                       

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('A' . $Ct, $row->cta_ctb_pry)                            
                                    ->setCellValue('C' . $Ct, number_format((int)$row->tdp_mto_pso, 0,'',''))
                                    ->setCellValue('D' . $Ct, $row->nom_cta_pry)                                
                                    ->setCellValue('P' . $Ct, $iDesCco);
                    }

                }else{

                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('A' . $Ct, $row->cta_ctb_pry)                            
                                ->setCellValue('C' . $Ct, number_format((int)$row->tdp_mto_pso, 0,'',''))
                                ->setCellValue('D' . $Ct, $row->nom_cta_pry);                                
                } 
                //---------------------------------------------------------------------------------------------------

                 $Ct = $Ct + 1; 
                
                //---------------------------------------------------------------------------------------------------
                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('A' . $Ct, $row->cta_ctb_bco)                            
                            ->setCellValue('B' . $Ct, number_format((int)$row->tdp_mto_pso, 0,'',''))
                            ->setCellValue('D' . $Ct, $row->nom_cta_bco)
                            ->setCellValue('Q' . $Ct, 'AB')
                            ->setCellValue('R' . $Ct, $row->num_doc_cnl);  
                //---------------------------------------------------------------------------------------------------                                                       

            }else{ //EGRESO                

                //---------------------------------------------------------------------------------------------------
                if($row->cta_mer_pry === '100'){ // contra parte no es cuenta mercatil

                    if($row->tmc_cod_cco === '0'){ // Si Código Centro de costo = 0 pinta valores tengo dudas ????????

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('A' . $Ct, $row->cta_ctb_pry)                            
                                    ->setCellValue('B' . $Ct, number_format((int)$row->tdp_mto_pso, 0,'',''))
                                    ->setCellValue('D' . $Ct, $row->nom_cta_pry)                                
                                    ->setCellValue('S' . $Ct, $row->tmp_rut_aux)
                                    ->setCellValue('T' . $Ct, $row->abr_tdc_pry)
                                    ->setCellValue('U' . $Ct, $row->tdp_num_doc)
                                    ->setCellValue('V' . $Ct, $row->tdp_fec_mvt)
                                    ->setCellValue('W' . $Ct, $row->tdp_fec_mvt)
                                    ->setCellValue('X' . $Ct, $row->abr_tdc_ref)
                                    ->setCellValue('Y' . $Ct, $row->tdp_num_ref); 

                    }else{

                        $aDesCcoSep = explode("-",$row->tmc_des_cco); 
                        $iDesCco = $aDesCcoSep[0] . '-' . $aDesCcoSep[1] . '-' . $aDesCcoSep[2];

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('A' . $Ct, $row->cta_ctb_pry)                            
                                    ->setCellValue('B' . $Ct, number_format((int)$row->tdp_mto_pso, 0,'',''))
                                    ->setCellValue('D' . $Ct, $row->nom_cta_pry)                                
                                    ->setCellValue('P' . $Ct, $iDesCco);                                    
                    }

                }else{

                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('A' . $Ct, $row->cta_ctb_pry)                            
                                ->setCellValue('B' . $Ct, number_format((int)$row->tdp_mto_pso, 0,'',''))
                                ->setCellValue('D' . $Ct, $row->nom_cta_pry);
                }
                //---------------------------------------------------------------------------------------------------

                $Ct = $Ct + 1;

                //---------------------------------------------------------------------------------------------------
                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('A' . $Ct, $row->cta_ctb_bco)                            
                            ->setCellValue('C' . $Ct, number_format((int)$row->tdp_mto_pso, 0,'',''))
                            ->setCellValue('D' . $Ct, $row->nom_cta_bco)
                            ->setCellValue('Q' . $Ct, 'CB')
                            ->setCellValue('R' . $Ct, $row->num_doc_cnl);
                //---------------------------------------------------------------------------------------------------

            }           

        }
        //********************************************************************************************
                    
        $objPHPExcel->getActiveSheet()->setTitle($row->tsp_nom_fan);
        $objPHPExcel->setActiveSheetIndex(0);               
        
        $aColArr = array('A','B','C','D','Q','R','S','T','U','V','W','X','Y','Z');

        foreach ($aColArr as $col) {
            # code...
            $objPHPExcel->getActiveSheet()->getColumnDimension($col)->setWidth(15);
        }       
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="ItzFljDia' . $row->tsp_nom_fan . '.csv"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       
        
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');     
    }

    Public Function fnc_exp_exc_flj_dri_BKPs()
    {
        /*[AUT-20200422 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                        
        
        /*[AUT-20200422 : Parametros de Entrada desde ExtJS]*/
        $iFecFlj = $data[0];
        $iTipFlj = $data[1];

        $iCttColBco = 0;

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set("memory_limit", "-1");
        set_time_limit(0);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);           
        
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion"); 

        //**********************************************************
         //Unir celdas 
        $objPHPExcel->getActiveSheet()
                    ->mergeCells('B2:B3');

        $objPHPExcel->getActiveSheet()                    
                    ->getStyle('B2:B3')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(15)
                    ->setBold()        
                    ->getColor();

         $objPHPExcel->getActiveSheet()
                     ->getStyle('B2:B3')
                     ->getFill()
                     ->applyFromArray(array(
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'startcolor' => array(
                                                'rgb' => 'FFFFCC'
                                            )
                            ));

        $objPHPExcel->getActiveSheet()
                    ->getStyle('B2')
                    ->getAlignment()
                    ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('B2', fcf_cmb_fec($iFecFlj));        
        //**********************************************************               
       

         //Unir celdas PRY
        $objPHPExcel->getActiveSheet()->mergeCells('C5:C8');
        //Unir celdas RAL
        $objPHPExcel->getActiveSheet()->mergeCells('D5:D8');
        //Unir celdas DIF
        $objPHPExcel->getActiveSheet()->mergeCells('E5:E8');

        $objPHPExcel->setActiveSheetIndex(0)

                    ->setCellValue('B5', 'Empresa')
                    ->setCellValue('B6', 'RUT')
                    ->setCellValue('B7', 'Bancos')
                    ->setCellValue('B8', 'Ctas. Corrientes')

                    ->setCellValue('C5', 'PROYECTADO')
                    ->setCellValue('D5', 'REAL')                    
                    ->setCellValue('E5', 'DIF');  

        // Conf primeras columnas hasta DIF***************************
        for ($i=5; $i <= 8; $i++) { 
            # code...

            //Configuración de tipos de letra                         
            $objPHPExcel->getActiveSheet()                    
                        ->getStyle('B' . $i . ':' . 'E' . $i)
                        ->getFont()
                        ->setName('Calibri')
                        ->setSize(8)
                        ->setBold()        
                        ->getColor();                        

            //fondo a celda
            $objPHPExcel->getActiveSheet()                    
                        ->getStyle('B' . $i . ':' . 'E' . $i)
                        ->getFill()
                        ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                        ->getStartColor()
                        ->setARGB('&H808080');
        }
        //************************************************************** 

        $iEmpHld = $this->mdl_exp_exc->mdl_csu_scd_flj($iTipFlj);  

         foreach ($iEmpHld as $emp) {
                            
            $iCtsBco = $this->mdl_exp_exc->mdl_csu_bco_sdp(0,$emp->tsp_cod_sdp);                        

            if($iCtsBco){               

                $iUltColBco = $objPHPExcel->getActiveSheet()->getHighestColumn();

                $iUltColEmp = $objPHPExcel->getActiveSheet()->getHighestColumn();

                foreach ($iCtsBco as $bco) {   
                  
                    $iUltColBco++;

                    /*Tipo de Letra Banco*/
                    $objPHPExcel->getActiveSheet()
                                ->getStyle($iUltColBco . '7')                                
                                ->getFont()
                                ->setName('Calibri')
                                ->setSize(9)
                                ->setBold()
                                ->getColor();                               

                    /*Tipo de Letra N° Ctas.*/
                    $objPHPExcel->getActiveSheet()
                                ->getStyle($iUltColBco . '8')                                
                                ->getFont()
                                ->setName('Calibri')
                                ->setSize(10)
                                ->setBold()
                                ->getColor();                                

                    /*Centrar Celdas Banco*/            
                    $objPHPExcel->getActiveSheet()
                                ->getStyle($iUltColBco . '7')
                                ->getAlignment()
                                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

                     /*Centrar Celdas N° Ctas.*/            
                    $objPHPExcel->getActiveSheet()
                                ->getStyle($iUltColBco . '8')
                                ->getAlignment()
                                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

                     /*Fondo a celda Banco*/
                    $objPHPExcel->getActiveSheet()                    
                                ->getStyle($iUltColBco . '7')
                                ->getFill()
                                ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                                ->getStartColor()
                                ->setARGB('&H808080'); 

                    /*Fondo a celda N° Ctas.*/
                    $objPHPExcel->getActiveSheet()                    
                                ->getStyle($iUltColBco . '8')
                                ->getFill()
                                ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                                ->getStartColor()
                                ->setARGB('&H808080');
                    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($iUltColBco .'7' , $bco->tmb_des_bco)
                                ->setCellValue($iUltColBco .'8' , $bco->tbs_num_cta); 


                    $iCttColBco++;  

                }

               $iUltColEmp++;

                /*Centrar Celdas Holding*/            
                $objPHPExcel->getActiveSheet()
                            ->mergeCells($iUltColEmp . '5:' . $iUltColBco . '5')
                            ->getStyle($iUltColEmp . '5:' . $iUltColBco . '5')                            
                            ->getAlignment()
                            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

                /*Centrar Celdas RUT*/            
                $objPHPExcel->getActiveSheet()
                            ->mergeCells($iUltColEmp . '6:' . $iUltColBco . '6')
                            ->getStyle($iUltColEmp . '6:' . $iUltColBco . '6')                            
                            ->getAlignment()
                            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER); 


                 /*Fondo a celda Holding*/
                $objPHPExcel->getActiveSheet()                    
                            ->getStyle($iUltColEmp . '5:' . $iUltColBco . '5')
                            ->getFill()
                            ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                            ->getStartColor()
                            ->setARGB('&H808080'); 

                /*Fondo a celda N° RUT.*/
                $objPHPExcel->getActiveSheet()                    
                            ->getStyle($iUltColEmp . '6:' . $iUltColBco . '6')
                            ->getFill()
                            ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                            ->getStartColor()
                            ->setARGB('&H808080');               

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue($iUltColEmp . '5' , $emp->tsp_nom_fan)                            
                            ->setCellValue($iUltColEmp . '6' , $emp->tsp_rut_sdp . '-' . $emp->tsp_dvf_sdp);                
               
            }               
        }         
        
               
        $flujo = $this->mdl_exp_exc->mdl_csu_flj_dri($iFecFlj . ' 00:00:00',$iTipFlj);
       

        $Ct = 8;
        
        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(false)        
                    ->getColor();        
        
        $iTipIng = false;   
        $iTipEgr = false;
        $iSdoCrl = false;

        $sSumIngPry = 0;
        $sSumIngRal = 0;
        $sSumIngDif = 0;

        $sSumEgrPry = 0;
        $sSumEgrRal = 0;
        $sSumEgrDif = 0;

        $CtSumIng = 0;
        $CtSumEgr = 0;

        for($i=1; $i <= $iCttColBco; $i++) {

            ${"sSumIng" . $i} = 0;
            ${"sSumEgr" . $i} = 0;                                                            
        }  

        foreach ($flujo as $flu)     
        { 
            switch ($flu->tmp_egr_ing) {
                case '0':
                    # code...
                    $Ct = $Ct + 2;  

                    /*tamaño letra en grilla*/
                    $objPHPExcel->getActiveSheet()
                                ->getStyle('B' . $Ct)
                                ->getFont()
                                ->setBold(true)
                                ->setName('Calibri')
                                ->setSize(9)
                                ->getColor();
                                

                    for($i=1,$j='B';$i <= ($iCttColBco + 4);$i++,$j++) {

                        $objPHPExcel->getActiveSheet()
                                    ->getStyle($j . $Ct)
                                    ->getFill()
                                    ->applyFromArray(array(
                                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                            'startcolor' => array(
                                                                'rgb' => 'E4DFEC'
                                                            )
                                            ));
                    }         

                    break;

                case '1':                
                    # code...
                    if(!$iTipIng){

                        $Ct = $Ct + 2;

                        /*tamaño letra en grilla*/
                         $objPHPExcel->getActiveSheet()
                                    ->getStyle('B' . $Ct)
                                    ->getFont()
                                    ->setBold(true)
                                    ->setName('Calibri')
                                    ->setSize(14); 

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('B' . $Ct,'INGRESOS');

                        $iTipIng = true;
                    }

                    $Ct++;

                    $objPHPExcel->getActiveSheet()
                                ->getStyle('B' . $Ct)
                                ->getFill()
                                ->applyFromArray(array(
                                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                        'startcolor' => array(
                                                            'rgb' => 'FFFFCC'
                                                        )
                                        ));

                    $objPHPExcel->getActiveSheet()
                                ->getStyle('C' . $Ct)
                                ->getFill()
                                ->applyFromArray(array(
                                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                        'startcolor' => array(
                                                            'rgb' => 'F89C52'
                                                        )
                                        ));

                    $objPHPExcel->getActiveSheet()
                                ->getStyle('D' . $Ct)
                                ->getFill()
                                ->applyFromArray(array(
                                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                        'startcolor' => array(
                                                            'rgb' => 'D8E4BC'
                                                        )
                                        ));

                break;

                case '2':                
                    # code...
                    if(!$iTipEgr){

                        $Ct++;

                        /*tamaño letra en grilla*/
                         $objPHPExcel->getActiveSheet()
                                    ->getStyle('B' . $Ct)
                                    ->getFont()
                                    ->setBold(true)
                                    ->setName('Calibri')
                                    ->setSize(9);

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('B' . $Ct,'SUMA INGRESO');

                        //********
                        // COL SUMA INGRESO                       
                        $CtSumIng = $Ct;                       
                        //********

                        for($i=1,$j='B';$i <= ($iCttColBco + 4);$i++,$j++) {

                            $objPHPExcel->getActiveSheet()
                                        ->getStyle($j . $Ct)
                                        ->getFill()
                                        ->applyFromArray(array(
                                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                                'startcolor' => array(
                                                                    'rgb' => 'E4DFEC'
                                                                )
                                                ));
                        }     

                        $Ct = $Ct + 2;



                        /*tamaño letra en grilla*/
                         $objPHPExcel->getActiveSheet()
                                    ->getStyle('B' . $Ct)
                                    ->getFont()
                                    ->setBold(true)
                                    ->setName('Calibri')
                                    ->setSize(14);

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('B' . $Ct,'EGRESOS');

                        $iTipEgr = true;
                    }


                    $Ct++;

                    $objPHPExcel->getActiveSheet()
                                ->getStyle('B' . $Ct)
                                ->getFill()
                                ->applyFromArray(array(
                                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                        'startcolor' => array(
                                                            'rgb' => 'FFFFCC'
                                                        )
                                        ));

                    $objPHPExcel->getActiveSheet()
                                ->getStyle('C' . $Ct)
                                ->getFill()
                                ->applyFromArray(array(
                                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                        'startcolor' => array(
                                                            'rgb' => 'F89C52'
                                                        )
                                        ));

                    $objPHPExcel->getActiveSheet()
                                ->getStyle('D' . $Ct)
                                ->getFill()
                                ->applyFromArray(array(
                                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                        'startcolor' => array(
                                                            'rgb' => 'D8E4BC'
                                                        )
                                        ));

                break;

                case '4':                
                    # code...  
                    $Ct++;

                    /*tamaño letra en grilla*/
                     $objPHPExcel->getActiveSheet()
                                ->getStyle('B' . $Ct)
                                ->getFont()
                                ->setBold(true)
                                ->setName('Calibri')
                                ->setSize(9);

                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('B' . $Ct,'SUMA EGRESOS');

                    // COL SUMA EGRESO
                    $CtSumEgr = $Ct;

                    for($i=1,$j='B';$i <= ($iCttColBco + 4);$i++,$j++) {

                            $objPHPExcel->getActiveSheet()
                                        ->getStyle($j . $Ct)
                                        ->getFill()
                                        ->applyFromArray(array(
                                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                                'startcolor' => array(
                                                                    'rgb' => 'E4DFEC'
                                                                )
                                                ));
                    }   

                    $Ct = $Ct + 2;                                       

                    for($i=1,$j='B';$i <= ($iCttColBco + 4);$i++,$j++) {

                        $objPHPExcel->getActiveSheet()
                                    ->getStyle($j . $Ct)
                                    ->getFill()
                                    ->applyFromArray(array(
                                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                            'startcolor' => array(
                                                                'rgb' => 'E6B8B7'
                                                            )
                                            ));
                    }

                break;
                
                case '5':                
                    # code...  

                    /*tamaño letra en grilla*/
                     $objPHPExcel->getActiveSheet()
                                ->getStyle('B' . $Ct)
                                ->getFont()
                                ->setBold(true)
                                ->setName('Calibri')
                                ->setSize(9);

                    $Ct = $Ct + 2; 

                break;

                case '6':                
                    # code...               
                     if(!$iSdoCrl){                  

                       $Ct++;
                        
                        $iSdoCrl = true;
                    }

                    $Ct++;

                break;
                
            }

            
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('B' . $Ct, $flu->trf_des_rfl)
                        ->setCellValue('C' . $Ct, $flu->tmp_val_pry)  
                        ->setCellValue('D' . $Ct, $flu->tmp_val_ral)
                        ->setCellValue('E' . $Ct, $flu->tmp_val_dif); 


                         switch ($flu->tmp_egr_ing) {

                                case '1':
                                   
                                    $sSumIngPry = $sSumIngPry + $flu->tmp_val_pry;
                                    $sSumIngRal = $sSumIngRal + $flu->tmp_val_ral;
                                    $sSumIngDif = $sSumIngDif + $flu->tmp_val_dif;                             

                                break;

                                case '2':                                                                           

                                    $sSumEgrPry = $sSumEgrPry + $flu->tmp_val_pry;
                                    $sSumEgrRal = $sSumEgrRal + $flu->tmp_val_ral;
                                    $sSumEgrDif = $sSumEgrDif + $flu->tmp_val_dif;

                                break;
                        }                       
                       
                        for($i=1,$j='F';$i<=$iCttColBco;$i++,$j++) {

                            $tmp_mto_flj = 'tmp_mto_flj' . $i;

                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue($j . $Ct, $flu->$tmp_mto_flj);                          
                           

                            switch ($flu->tmp_egr_ing) {

                                case '1':

                                    $objPHPExcel->getActiveSheet()
                                                ->getStyle($j . $Ct)
                                                ->getFill()
                                                ->applyFromArray(array(
                                                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                                        'startcolor' => array(
                                                                            'rgb' => 'FFFFCC'
                                                                        )
                                                        ));

                                    ${"sSumIng" . $i} = ${"sSumIng" . $i} + $flu->$tmp_mto_flj;                               

                                break;

                                case '2':

                                    $objPHPExcel->getActiveSheet()
                                                ->getStyle($j . $Ct)
                                                ->getFill()
                                                ->applyFromArray(array(
                                                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                                        'startcolor' => array(
                                                                            'rgb' => 'FFFFCC'
                                                                        )
                                                        ));                                                

                                    ${"sSumEgr" . $i} = ${"sSumEgr" . $i} + $flu->$tmp_mto_flj;                                   

                                break;
                            }

                            $objPHPExcel->getActiveSheet()
                                        ->getStyle($j.$Ct)
                                        ->getNumberFormat()
                                        ->setFormatCode('$#,##0;[Red]-$#,##0'); 

                            $objPHPExcel->getActiveSheet()->getColumnDimension($j)->setAutoSize(true);
                                                                      
                        }  

                                 


            $objPHPExcel->getActiveSheet()->getStyle('C' . $Ct )->getNumberFormat()->setFormatCode('$#,##0;[Red]-$#,##0'); 
            $objPHPExcel->getActiveSheet()->getStyle('D' . $Ct )->getNumberFormat()->setFormatCode('$#,##0;[Red]-$#,##0'); 
            $objPHPExcel->getActiveSheet()->getStyle('E' . $Ct )->getNumberFormat()->setFormatCode('$#,##0;[Red]-$#,##0');            

        }  

        // SUMA DE INGRESO Y EGRESO 
        for($i=1,$j='F';$i<=$iCttColBco;$i++,$j++) {

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue($j . $CtSumIng, ${"sSumIng" . $i});

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue($j . $CtSumEgr, ${"sSumEgr" . $i});

            $objPHPExcel->getActiveSheet()
                        ->getStyle($j . $CtSumIng)
                        ->getNumberFormat()
                        ->setFormatCode('$#,##0;[Red]-$#,##0');

            $objPHPExcel->getActiveSheet()
                        ->getStyle($j . $CtSumEgr)
                        ->getNumberFormat()
                        ->setFormatCode('$#,##0;[Red]-$#,##0');

        }
        

        //Suma de Ingresos columnas PRY RAL DIF
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('C' . $CtSumIng, $sSumIngPry);

         $objPHPExcel->getActiveSheet()
                    ->getStyle('C' . $CtSumIng)
                    ->getNumberFormat()
                    ->setFormatCode('$#,##0;[Red]-$#,##0');
            
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('D' . $CtSumIng, $sSumIngRal);

        $objPHPExcel->getActiveSheet()
                    ->getStyle('D' . $CtSumIng)
                    ->getNumberFormat()
                    ->setFormatCode('$#,##0;[Red]-$#,##0');
                    
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('E' . $CtSumIng, $sSumIngDif);

        $objPHPExcel->getActiveSheet()
                    ->getStyle('E' . $CtSumIng)
                    ->getNumberFormat()
                    ->setFormatCode('$#,##0;[Red]-$#,##0');
        //*******************************************************           
                   
        //Suma de Egresos columnas PRY RAL DIF 
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('C' . $CtSumEgr, $sSumEgrPry);

        $objPHPExcel->getActiveSheet()
                    ->getStyle('C' . $CtSumEgr)
                    ->getNumberFormat()
                    ->setFormatCode('$#,##0;[Red]-$#,##0');
                    
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('D' . $CtSumEgr, $sSumEgrRal);

        $objPHPExcel->getActiveSheet()
                    ->getStyle('D' . $CtSumEgr)
                    ->getNumberFormat()
                    ->setFormatCode('$#,##0;[Red]-$#,##0');
                    
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('E' . $CtSumEgr, $sSumEgrDif);

        $objPHPExcel->getActiveSheet()
                    ->getStyle('E' . $CtSumEgr)
                    ->getNumberFormat()
                    ->setFormatCode('$#,##0;[Red]-$#,##0');
        //*******************************************************

        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);

        $aColArr = array('C','D','E');       

        foreach ($aColArr as $col) {
            # code...
            $objPHPExcel->getActiveSheet()->getColumnDimension($col)->setWidth(15);
        } 


        $objPHPExcel->getActiveSheet()->setTitle('01-10-2018');
        $objPHPExcel->setActiveSheetIndex(0);         
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Listado_de_Flujo.xls"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       
        
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');      
    }

    Public Function fnc_exp_exc_flj_dri()
    {
        /*[AUT-20200422 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                        
        
        /*[AUT-20200422 : Parametros de Entrada desde ExtJS]*/
        $iFecFlj = $data[0];
        $iTipFlj = $data[1];

        $iCttColBco = 0;

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set("memory_limit", "-1");
        set_time_limit(0);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);           
        
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion"); 

        //**********************************************************
         //Unir celdas 
        $objPHPExcel->getActiveSheet()
                    ->mergeCells('B2:B3');

        $objPHPExcel->getActiveSheet()                    
                    ->getStyle('B2:B3')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(15)
                    ->setBold()        
                    ->getColor();

         $objPHPExcel->getActiveSheet()
                     ->getStyle('B2:B3')
                     ->getFill()
                     ->applyFromArray(array(
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'startcolor' => array(
                                                'rgb' => 'FFFFCC'
                                            )
                            ));

        $objPHPExcel->getActiveSheet()
                    ->getStyle('B2')
                    ->getAlignment()
                    ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('B2', fcf_cmb_fec($iFecFlj));        
        //**********************************************************               
       

         //Unir celdas PRY
        $objPHPExcel->getActiveSheet()->mergeCells('C5:C8');
        //Unir celdas RAL
        $objPHPExcel->getActiveSheet()->mergeCells('D5:D8');
        //Unir celdas DIF
        $objPHPExcel->getActiveSheet()->mergeCells('E5:E8');

        $objPHPExcel->setActiveSheetIndex(0)

                    ->setCellValue('B5', 'Empresa')
                    ->setCellValue('B6', 'RUT')
                    ->setCellValue('B7', 'Bancos')
                    ->setCellValue('B8', 'Ctas. Corrientes')

                    ->setCellValue('C5', 'PROYECTADO')
                    ->setCellValue('D5', 'REAL')                    
                    ->setCellValue('E5', 'DIF');  

        // Conf primeras columnas hasta DIF***************************
        for ($i=5; $i <= 8; $i++) { 
            # code...

            //Configuración de tipos de letra                         
            $objPHPExcel->getActiveSheet()                    
                        ->getStyle('B' . $i . ':' . 'E' . $i)
                        ->getFont()
                        ->setName('Calibri')
                        ->setSize(8)
                        ->setBold()        
                        ->getColor();                        

            //fondo a celda
            $objPHPExcel->getActiveSheet()                    
                        ->getStyle('B' . $i . ':' . 'E' . $i)
                        ->getFill()
                        ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                        ->getStartColor()
                        ->setARGB('&H808080');
        }
        //************************************************************** 

        $iEmpHld = $this->mdl_exp_exc->mdl_csu_scd_flj($iTipFlj);  

        foreach ($iEmpHld as $emp) {
                            
            $iCtsBco = $this->mdl_exp_exc->mdl_csu_bco_sdp(0,$emp->tsp_cod_sdp);                        

            if($iCtsBco){               

                $iUltColBco = $objPHPExcel->getActiveSheet()->getHighestColumn();

                $iUltColEmp = $objPHPExcel->getActiveSheet()->getHighestColumn();

                foreach ($iCtsBco as $bco) {   
                  
                    $iUltColBco++;

                    /*Tipo de Letra Banco*/
                    $objPHPExcel->getActiveSheet()
                                ->getStyle($iUltColBco . '7')                                
                                ->getFont()
                                ->setName('Calibri')
                                ->setSize(9)
                                ->setBold()
                                ->getColor();                               

                    /*Tipo de Letra N° Ctas.*/
                    $objPHPExcel->getActiveSheet()
                                ->getStyle($iUltColBco . '8')                                
                                ->getFont()
                                ->setName('Calibri')
                                ->setSize(10)
                                ->setBold()
                                ->getColor();                                

                    /*Centrar Celdas Banco*/            
                    $objPHPExcel->getActiveSheet()
                                ->getStyle($iUltColBco . '7')
                                ->getAlignment()
                                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

                     /*Centrar Celdas N° Ctas.*/            
                    $objPHPExcel->getActiveSheet()
                                ->getStyle($iUltColBco . '8')
                                ->getAlignment()
                                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

                     /*Fondo a celda Banco*/
                    $objPHPExcel->getActiveSheet()                    
                                ->getStyle($iUltColBco . '7')
                                ->getFill()
                                ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                                ->getStartColor()
                                ->setARGB('&H808080'); 

                    /*Fondo a celda N° Ctas.*/
                    $objPHPExcel->getActiveSheet()                    
                                ->getStyle($iUltColBco . '8')
                                ->getFill()
                                ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                                ->getStartColor()
                                ->setARGB('&H808080');
                    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($iUltColBco .'7' , $bco->tmb_des_bco)
                                ->setCellValue($iUltColBco .'8' , $bco->tbs_num_cta); 


                    $iCttColBco++;  

                }

               $iUltColEmp++;

                /*Centrar Celdas Holding*/            
                $objPHPExcel->getActiveSheet()
                            ->mergeCells($iUltColEmp . '5:' . $iUltColBco . '5')
                            ->getStyle($iUltColEmp . '5:' . $iUltColBco . '5')                            
                            ->getAlignment()
                            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

                /*Centrar Celdas RUT*/            
                $objPHPExcel->getActiveSheet()
                            ->mergeCells($iUltColEmp . '6:' . $iUltColBco . '6')
                            ->getStyle($iUltColEmp . '6:' . $iUltColBco . '6')                            
                            ->getAlignment()
                            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER); 


                 /*Fondo a celda Holding*/
                $objPHPExcel->getActiveSheet()                    
                            ->getStyle($iUltColEmp . '5:' . $iUltColBco . '5')
                            ->getFill()
                            ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                            ->getStartColor()
                            ->setARGB('&H808080'); 

                /*Fondo a celda N° RUT.*/
                $objPHPExcel->getActiveSheet()                    
                            ->getStyle($iUltColEmp . '6:' . $iUltColBco . '6')
                            ->getFill()
                            ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                            ->getStartColor()
                            ->setARGB('&H808080');               

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue($iUltColEmp . '5' , $emp->tsp_nom_fan)                            
                            ->setCellValue($iUltColEmp . '6' , $emp->tsp_rut_sdp . '-' . $emp->tsp_dvf_sdp);                
               
            }               
        }         
        
               
        $flujo = $this->mdl_exp_exc->mdl_csu_flj_dri($iFecFlj . ' 00:00:00',$iTipFlj);
       

        $Ct = 8;
        
        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(false)        
                    ->getColor();        
        
        $iTipIng = false;   
        $iTipEgr = false;
        $iSdoCrl = false;

        $sSumIngPry = 0;
        $sSumIngRal = 0;
        $sSumIngDif = 0;

        $sSumEgrPry = 0;
        $sSumEgrRal = 0;
        $sSumEgrDif = 0;

        $CtSumIng = 0;
        $CtSumEgr = 0;

        for($i=1; $i <= $iCttColBco; $i++) {

            ${"sSumIng" . $i} = 0;
            ${"sSumEgr" . $i} = 0;                                                            
        }  

        foreach ($flujo as $flu)     
        { 
            switch ($flu->tmp_egr_ing) {
                
                case '0':
                    # code...
                    $Ct = $Ct + 2;  

                    /*tamaño letra en grilla*/
                    $objPHPExcel->getActiveSheet()
                                ->getStyle('B' . $Ct)
                                ->getFont()
                                ->setBold(true)
                                ->setName('Calibri')
                                ->setSize(9)
                                ->getColor();
                                

                    for($i=1,$j='B';$i <= ($iCttColBco + 4);$i++,$j++) {

                        $objPHPExcel->getActiveSheet()
                                    ->getStyle($j . $Ct)
                                    ->getFill()
                                    ->applyFromArray(array(
                                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                            'startcolor' => array(
                                                                'rgb' => 'E4DFEC'
                                                            )
                                            ));
                    }  

                    for($i=1,$j='F';$i<=$iCttColBco;$i++,$j++) {

                        $tmp_mto_flj = 'tmp_mto_flj' . $i;

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($j . $Ct, $flu->$tmp_mto_flj);                                                   

                        $objPHPExcel->getActiveSheet()
                                    ->getStyle($j.$Ct)
                                    ->getNumberFormat()
                                    ->setFormatCode('$#,##0;[Red]-$#,##0'); 

                        $objPHPExcel->getActiveSheet()->getColumnDimension($j)->setAutoSize(true);                               
                    }       

                    break;

                case '1':                
                    # code...
                    if(!$iTipIng){

                        $Ct = $Ct + 2;

                        /*tamaño letra en grilla*/
                         $objPHPExcel->getActiveSheet()
                                    ->getStyle('B' . $Ct)
                                    ->getFont()
                                    ->setBold(true)
                                    ->setName('Calibri')
                                    ->setSize(14); 

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('B' . $Ct,'INGRESOS');

                        $iTipIng = true;
                    }

                    $Ct++;

                    $objPHPExcel->getActiveSheet()
                                ->getStyle('B' . $Ct)
                                ->getFill()
                                ->applyFromArray(array(
                                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                        'startcolor' => array(
                                                            'rgb' => 'FFFFCC'
                                                        )
                                        ));

                    $objPHPExcel->getActiveSheet()
                                ->getStyle('C' . $Ct)
                                ->getFill()
                                ->applyFromArray(array(
                                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                        'startcolor' => array(
                                                            'rgb' => 'F89C52'
                                                        )
                                        ));

                    $objPHPExcel->getActiveSheet()
                                ->getStyle('D' . $Ct)
                                ->getFill()
                                ->applyFromArray(array(
                                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                        'startcolor' => array(
                                                            'rgb' => 'D8E4BC'
                                                        )
                                        ));                                                           

                    $sSumIngPry = $sSumIngPry + $flu->tmp_val_pry;
                    $sSumIngRal = $sSumIngRal + $flu->tmp_val_ral;
                    $sSumIngDif = $sSumIngDif + $flu->tmp_val_dif; 

                    for($i=1,$j='F';$i<=$iCttColBco;$i++,$j++) {

                        $tmp_mto_flj = 'tmp_mto_flj' . $i;

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($j . $Ct, $flu->$tmp_mto_flj);

                        $objPHPExcel->getActiveSheet()
                                    ->getStyle($j . $Ct)
                                    ->getFill()
                                    ->applyFromArray(array(
                                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                            'startcolor' => array(
                                                                'rgb' => 'FFFFCC'
                                                            )
                                            ));

                        ${"sSumIng" . $i} = ${"sSumIng" . $i} + $flu->$tmp_mto_flj;                                

                        $objPHPExcel->getActiveSheet()
                                    ->getStyle($j.$Ct)
                                    ->getNumberFormat()
                                    ->setFormatCode('$#,##0;[Red]-$#,##0'); 

                        $objPHPExcel->getActiveSheet()->getColumnDimension($j)->setAutoSize(true);                              
                    }                         

                break;

                case '2':                
                    # code...
                    if(!$iTipEgr){

                        $Ct++;

                        /*tamaño letra en grilla*/
                         $objPHPExcel->getActiveSheet()
                                    ->getStyle('B' . $Ct)
                                    ->getFont()
                                    ->setBold(true)
                                    ->setName('Calibri')
                                    ->setSize(9);

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('B' . $Ct,'SUMA INGRESO');

                        //********
                        // COL SUMA INGRESO                       
                        $CtSumIng = $Ct;                       
                        //********

                        for($i=1,$j='B';$i <= ($iCttColBco + 4);$i++,$j++) {

                            $objPHPExcel->getActiveSheet()
                                        ->getStyle($j . $Ct)
                                        ->getFill()
                                        ->applyFromArray(array(
                                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                                'startcolor' => array(
                                                                    'rgb' => 'E4DFEC'
                                                                )
                                                ));
                        }     

                        $Ct = $Ct + 2;



                        /*tamaño letra en grilla*/
                         $objPHPExcel->getActiveSheet()
                                    ->getStyle('B' . $Ct)
                                    ->getFont()
                                    ->setBold(true)
                                    ->setName('Calibri')
                                    ->setSize(14);

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('B' . $Ct,'EGRESOS');

                        $iTipEgr = true;
                    }

                    $Ct++;

                    $objPHPExcel->getActiveSheet()
                                ->getStyle('B' . $Ct)
                                ->getFill()
                                ->applyFromArray(array(
                                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                        'startcolor' => array(
                                                            'rgb' => 'FFFFCC'
                                                        )
                                        ));

                    $objPHPExcel->getActiveSheet()
                                ->getStyle('C' . $Ct)
                                ->getFill()
                                ->applyFromArray(array(
                                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                        'startcolor' => array(
                                                            'rgb' => 'F89C52'
                                                        )
                                        ));

                    $objPHPExcel->getActiveSheet()
                                ->getStyle('D' . $Ct)
                                ->getFill()
                                ->applyFromArray(array(
                                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                        'startcolor' => array(
                                                            'rgb' => 'D8E4BC'
                                                        )
                                        ));

                    $sSumEgrPry = $sSumEgrPry + $flu->tmp_val_pry;
                    $sSumEgrRal = $sSumEgrRal + $flu->tmp_val_ral;
                    $sSumEgrDif = $sSumEgrDif + $flu->tmp_val_dif;

                    for($i=1,$j='F';$i<=$iCttColBco;$i++,$j++) {

                        $tmp_mto_flj = 'tmp_mto_flj' . $i;

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($j . $Ct, $flu->$tmp_mto_flj);                  

                        $objPHPExcel->getActiveSheet()
                                    ->getStyle($j . $Ct)
                                    ->getFill()
                                    ->applyFromArray(array(
                                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                            'startcolor' => array(
                                                                'rgb' => 'FFFFCC'
                                                            )
                                            ));                                                

                        ${"sSumEgr" . $i} = ${"sSumEgr" . $i} + $flu->$tmp_mto_flj; 

                        $objPHPExcel->getActiveSheet()
                                    ->getStyle($j.$Ct)
                                    ->getNumberFormat()
                                    ->setFormatCode('$#,##0;[Red]-$#,##0'); 

                        $objPHPExcel->getActiveSheet()->getColumnDimension($j)->setAutoSize(true);                               
                    }  

                break;

                case '4':                
                    # code...  
                    $Ct++;

                    /*tamaño letra en grilla*/
                    $objPHPExcel->getActiveSheet()
                                ->getStyle('B' . $Ct)
                                ->getFont()
                                ->setBold(true)
                                ->setName('Calibri')
                                ->setSize(9);

                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('B' . $Ct,'SUMA EGRESOS');

                    // COL SUMA EGRESO
                    $CtSumEgr = $Ct;

                    $CtColSdoFinISTAC = $Ct + 2;
                    
                    for($i=1,$j='B';$i <= ($iCttColBco + 4);$i++,$j++) {

                            $objPHPExcel->getActiveSheet()
                                        ->getStyle($j . $Ct)
                                        ->getFill()
                                        ->applyFromArray(array(
                                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                                'startcolor' => array(
                                                                    'rgb' => 'E4DFEC'
                                                                )
                                                ));

                            $objPHPExcel->getActiveSheet()
                                        ->getStyle($j . $CtColSdoFinISTAC)
                                        ->getFill()
                                        ->applyFromArray(array(
                                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                                'startcolor' => array(
                                                                    'rgb' => 'E6B8B7'
                                                                )
                                                ));
                    }  

                    $Ct = $Ct + 2;                                                          

                    for($i=1,$j='F';$i<=$iCttColBco;$i++,$j++) {

                        $tmp_mto_flj = 'tmp_mto_flj' . $i;

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($j . $Ct, $flu->$tmp_mto_flj);                                                   

                        $objPHPExcel->getActiveSheet()
                                    ->getStyle($j.$Ct)
                                    ->getNumberFormat()
                                    ->setFormatCode('$#,##0;[Red]-$#,##0'); 

                        $objPHPExcel->getActiveSheet()->getColumnDimension($j)->setAutoSize(true);                               
                    } 

                break;
                
                case '5':                
                    # code...  

                    /*tamaño letra en grilla*/
                     $objPHPExcel->getActiveSheet()
                                ->getStyle('B' . $Ct)
                                ->getFont()
                                ->setBold(true)
                                ->setName('Calibri')
                                ->setSize(9);

                    $Ct = $Ct + 2; 

                    for($i=1,$j='F';$i<=$iCttColBco;$i++,$j++) {

                        $tmp_mto_flj = 'tmp_mto_flj' . $i;

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($j . $Ct, $flu->$tmp_mto_flj);                                                   

                        $objPHPExcel->getActiveSheet()
                                    ->getStyle($j.$Ct)
                                    ->getNumberFormat()
                                    ->setFormatCode('$#,##0;[Red]-$#,##0'); 

                        $objPHPExcel->getActiveSheet()->getColumnDimension($j)->setAutoSize(true);                               
                    } 

                break;

                case '6':                
                    # code...               
                    if(!$iSdoCrl){                  

                       $Ct++;
                        
                       $iSdoCrl = true;
                    }

                    $Ct++;

                    for($i=1,$j='F';$i<=$iCttColBco;$i++,$j++) {

                        $tmp_mto_flj = 'tmp_mto_flj' . $i;

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($j . $Ct, $flu->$tmp_mto_flj);                                                   

                        $objPHPExcel->getActiveSheet()
                                    ->getStyle($j.$Ct)
                                    ->getNumberFormat()
                                    ->setFormatCode('$#,##0;[Red]-$#,##0'); 

                        $objPHPExcel->getActiveSheet()->getColumnDimension($j)->setAutoSize(true);                               
                    } 

                break;
                
            }
            
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('B' . $Ct, $flu->trf_des_rfl)
                        ->setCellValue('C' . $Ct, $flu->tmp_val_pry)  
                        ->setCellValue('D' . $Ct, $flu->tmp_val_ral)
                        ->setCellValue('E' . $Ct, $flu->tmp_val_dif); 

            $objPHPExcel->getActiveSheet()->getStyle('C' . $Ct )->getNumberFormat()->setFormatCode('$#,##0;[Red]-$#,##0'); 
            $objPHPExcel->getActiveSheet()->getStyle('D' . $Ct )->getNumberFormat()->setFormatCode('$#,##0;[Red]-$#,##0'); 
            $objPHPExcel->getActiveSheet()->getStyle('E' . $Ct )->getNumberFormat()->setFormatCode('$#,##0;[Red]-$#,##0');            

        }  

        // SUMA DE INGRESO Y EGRESO 
        for($i=1,$j='F';$i<=$iCttColBco;$i++,$j++) {

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue($j . $CtSumIng, ${"sSumIng" . $i});

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue($j . $CtSumEgr, ${"sSumEgr" . $i});

            $objPHPExcel->getActiveSheet()
                        ->getStyle($j . $CtSumIng)
                        ->getNumberFormat()
                        ->setFormatCode('$#,##0;[Red]-$#,##0');

            $objPHPExcel->getActiveSheet()
                        ->getStyle($j . $CtSumEgr)
                        ->getNumberFormat()
                        ->setFormatCode('$#,##0;[Red]-$#,##0');
        }
        

        //Suma de Ingresos columnas PRY RAL DIF
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('C' . $CtSumIng, $sSumIngPry);

         $objPHPExcel->getActiveSheet()
                    ->getStyle('C' . $CtSumIng)
                    ->getNumberFormat()
                    ->setFormatCode('$#,##0;[Red]-$#,##0');
            
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('D' . $CtSumIng, $sSumIngRal);

        $objPHPExcel->getActiveSheet()
                    ->getStyle('D' . $CtSumIng)
                    ->getNumberFormat()
                    ->setFormatCode('$#,##0;[Red]-$#,##0');
                    
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('E' . $CtSumIng, $sSumIngDif);

        $objPHPExcel->getActiveSheet()
                    ->getStyle('E' . $CtSumIng)
                    ->getNumberFormat()
                    ->setFormatCode('$#,##0;[Red]-$#,##0');
        //*******************************************************           
                   
        //Suma de Egresos columnas PRY RAL DIF 
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('C' . $CtSumEgr, $sSumEgrPry);

        $objPHPExcel->getActiveSheet()
                    ->getStyle('C' . $CtSumEgr)
                    ->getNumberFormat()
                    ->setFormatCode('$#,##0;[Red]-$#,##0');
                    
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('D' . $CtSumEgr, $sSumEgrRal);

        $objPHPExcel->getActiveSheet()
                    ->getStyle('D' . $CtSumEgr)
                    ->getNumberFormat()
                    ->setFormatCode('$#,##0;[Red]-$#,##0');
                    
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('E' . $CtSumEgr, $sSumEgrDif);

        $objPHPExcel->getActiveSheet()
                    ->getStyle('E' . $CtSumEgr)
                    ->getNumberFormat()
                    ->setFormatCode('$#,##0;[Red]-$#,##0');
        //*******************************************************

        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);

        $aColArr = array('C','D','E');       

        foreach ($aColArr as $col) {
            # code...
            $objPHPExcel->getActiveSheet()->getColumnDimension($col)->setWidth(15);
        } 


        $objPHPExcel->getActiveSheet()->setTitle('01-10-2018');
        $objPHPExcel->setActiveSheetIndex(0);         
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Listado_de_Flujo.xls"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       
        
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');      
    }   

    Public Function fnc_exp_exc_pry_cni()
    {
        /*[AUT-20191001 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                        
        
        /*[AUT-20191001 : Parametros de Entrada desde ExtJS]*/
        $iFecIniMvt = $data[0];
        $iFecFinMvt = $data[1];
        $iEmpHld    = $data[2];
        $iCtaBco    = $data[3];
        $iRegFlj    = $data[4];        
        $iCodFlj    = $data[5];        

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);        
        
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion");                                      
        
        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado de Detalle Proyeccion');        
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B2')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(15)
                    ->setBold(true)
                    ->getColor();        
               
        /*Centrar Celdas*/            
        $objPHPExcel->getActiveSheet()->getStyle('B5:J5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER); 

        $objPHPExcel->setActiveSheetIndex(0)                    
                    ->setCellValue('B5', 'Registro en Flujo')
                    ->setCellValue('C5', 'Agrupación')                    
                    ->setCellValue('D5', 'Empresa')
                    ->setCellValue('E5', 'Monto')                     
                    ->setCellValue('F5', 'Banco')                              
                    ->setCellValue('G5', 'Tipo de Cuenta') 
                    ->setCellValue('H5', 'N° de Cuenta')
                    ->setCellValue('I5', 'Origen')
                    ->setCellValue('J5', 'Fecha Movimiento');                            

        //Configuración de tipos de letra                         
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:J5')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(true)        
                    ->getColor()
                    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
                    
        //fondo a celda
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:J5')
                    ->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('&H808080');         

        $dconciliado = $this->mdl_exp_exc->mdl_csu_det_pry_cni(($iFecIniMvt <> '' ?  $iFecIniMvt . ' 00:00:00' : ''),
                                                               ($iFecFinMvt <> '' ?  $iFecFinMvt . ' 23:59:59' : ''),
                                                               $iEmpHld,
                                                               $iCtaBco,
                                                               $iRegFlj,
                                                               $iCodFlj);
        $Ct = 5;
        $i = 0;
        $x = 0;
        
        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(false)        
                    ->getColor();   
        
        $iLstIng = array();
        foreach ($dconciliado as $con)
        {            

            switch ($con->tae_tip_cta) {
    
                case '1':                
                    # code...   
                    $iLstIng[$x] = array($con->trf_des_rfl,
                                         $con->tae_des_aeg,
                                         $con->tsp_nom_fan,
                                         $con->tdp_mto_pso,
                                         $con->tmb_des_bco,
                                         $con->tbs_num_cta,
                                         $con->tbs_tip_cta,
                                         $con->tmp_tip_org,
                                         $con->tdp_fec_mvt);
                    $x++;                     

                break;

                case '2':                
                    # code...
                    $iLstEgr[$i] = array($con->trf_des_rfl,
                                         $con->tae_des_aeg,
                                         $con->tsp_nom_fan,
                                         $con->tdp_mto_pso,
                                         $con->tmb_des_bco,
                                         $con->tbs_num_cta,
                                         $con->tbs_tip_cta,
                                         $con->tmp_tip_org,
                                         $con->tdp_fec_mvt); 

                    $i++;                   

                break;                
            }      
        }   

        $Ct = $Ct + 2;

         /*tamaño letra en grilla*/
         $objPHPExcel->getActiveSheet()
                    ->getStyle('B' . $Ct)
                    ->getFont()
                    ->setBold(true)
                    ->setName('Calibri')
                    ->setSize(14); 

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('B' . $Ct, 'INGRESO');

        for($i=0;$i<count($iLstIng);$i++) {            

             $Ct = $Ct + 1;
                 
                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('B' . $Ct, $iLstIng[$i][0])
                            ->setCellValue('C' . $Ct, $iLstIng[$i][1])  
                            ->setCellValue('D' . $Ct, $iLstIng[$i][2])                             
                            ->setCellValue('E' . $Ct, $iLstIng[$i][3])                    
                            ->setCellValue('F' . $Ct, $iLstIng[$i][4])                             
                            ->setCellValue('G' . $Ct, $iLstIng[$i][5])                    
                            ->setCellValue('H' . $Ct, $iLstIng[$i][6])
                            ->setCellValue('I' . $Ct, $iLstIng[$i][7])
                            ->setCellValue('J' . $Ct, $iLstIng[$i][8]);

                $objPHPExcel->getActiveSheet()->getStyle('E' . $Ct )->getNumberFormat()->setFormatCode('$#,##0;[Red]-$#,##0'); 
                $objPHPExcel->getActiveSheet()->getStyle('J' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        }   


        $Ct = $Ct + 2;

         /*tamaño letra en grilla*/
         $objPHPExcel->getActiveSheet()
                    ->getStyle('B' . $Ct)
                    ->getFont()
                    ->setBold(true)
                    ->setName('Calibri')
                    ->setSize(14); 

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('B' . $Ct, 'EGRESO');

        for($i=0;$i<count($iLstEgr);$i++) {            

             $Ct = $Ct + 1;
                 
                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('B' . $Ct, $iLstEgr[$i][0])
                            ->setCellValue('C' . $Ct, $iLstEgr[$i][1])  
                            ->setCellValue('D' . $Ct, $iLstEgr[$i][2])                             
                            ->setCellValue('E' . $Ct, $iLstEgr[$i][3])                    
                            ->setCellValue('F' . $Ct, $iLstEgr[$i][4])                             
                            ->setCellValue('G' . $Ct, $iLstEgr[$i][5])                    
                            ->setCellValue('H' . $Ct, $iLstEgr[$i][6])
                            ->setCellValue('I' . $Ct, $iLstEgr[$i][7])
                            ->setCellValue('J' . $Ct, $iLstEgr[$i][8]);

                $objPHPExcel->getActiveSheet()->getStyle('E' . $Ct )->getNumberFormat()->setFormatCode('$#,##0;[Red]-$#,##0'); 
                $objPHPExcel->getActiveSheet()->getStyle('J' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        }         
                              
        $objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
        //Unir celdas 
        $objPHPExcel->getActiveSheet()->mergeCells('B2:D2');             

        $aColArr = array('A','B','C','D','E','F','G','H','I','J','K');
        
        foreach ($aColArr as $col) {
            # code...
            $objPHPExcel->getActiveSheet()->getColumnDimension($col)->setAutoSize(true);
        }        
                                    
        $objPHPExcel->getActiveSheet()->setTitle('Exportacion');
        $objPHPExcel->setActiveSheetIndex(0);         
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Listado_de_detalle_proyeccion.xls"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       
        
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');      
    }

    Public Function fnc_exp_exc_inf_dif()
    {
        /*[AUT-20200518 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                        
        
        /*[AUT-20200518 : Parametros de Entrada desde ExtJS]*/
        $iCodBdp       = $data[0];
        $iCodDpr       = $data[1];
        $iFecIniMvt    = $data[2];
        $iFecFinMvt    = $data[3];       
        $iEmpHld       = $data[4];
        $iCtaBco       = $data[5];
        $iRegFlj       = $data[6];  

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);        
        
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion");                                      
        
        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado de Informe de Diferencias');        
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B2')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(15)
                    ->setBold(true)
                    ->getColor();        
               
        /*Centrar Celdas*/            
        $objPHPExcel->getActiveSheet()->getStyle('B5:G5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
        $objPHPExcel->setActiveSheetIndex(0)                    
                    ->setCellValue('B5', 'Banco')
                    ->setCellValue('C5', 'N° Cuenta')
                    ->setCellValue('D5', 'Registro en Flujo')
                    ->setCellValue('E5', 'Moneda Org.')
                    ->setCellValue('F5', 'Cambio Org.')
                    ->setCellValue('G5', 'Cambio Nvo.')
                    ->setCellValue('H5', 'Fecha Cambio Org.')
                    ->setCellValue('I5', 'Fecha Cambio Nvo.')
                    ->setCellValue('J5', 'Fecha Movimiento Org.')
                    ->setCellValue('K5', 'Fecha Movimiento Nvo.')
                    ->setCellValue('L5', 'Mnt. Acl. Org.')
                    ->setCellValue('M5', 'Mnt. Org. Nvo.')
                    ->setCellValue('N5', 'Mnt. Acl. PESOS')
                    ->setCellValue('O5', 'Mnt. Nvo. PESOS')
                    ->setCellValue('P5', 'Mnt. Diferencia PESOS')
                    ->setCellValue('Q5', 'Banco - N° Cta. Org.')
                    ->setCellValue('R5', 'Banco - N° Cta. Nvo.')
                    ->setCellValue('S5', 'Motivo')
                    ->setCellValue('T5', 'Observación')
                    ->setCellValue('U5', 'Usuario');                 

        //Configuración de tipos de letra                         
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:U5')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(true)        
                    ->getColor()
                    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
                    
        //fondo a celda
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:U5')
                    ->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('&H808080');         

        $informe = $this->mdl_exp_exc->mdl_csu_btc_dpr($iCodBdp,
                                                       $iCodDpr,
                                                       ($iFecIniMvt <> '' ?  $iFecIniMvt . ' 00:00:00' : ''),
                                                       ($iFecFinMvt <> '' ?  $iFecFinMvt . ' 23:59:59' : ''),                       
                                                       $iEmpHld,
                                                       $iCtaBco,
                                                       $iRegFlj);

        $Ct = 5;
        
        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(false)        
                    ->getColor(); 
         
       
        foreach ($informe as $inf)
        {

            $data_array[] = array('tsp_nom_fan' => $inf->tsp_nom_fan,                                  
                                  'tmb_des_bco' => $inf->tmb_des_bco,
                                  'tbs_num_cta' => $inf->tbs_num_cta,
                                  'trf_des_rfl' => $inf->trf_des_rfl,
                                  'ttg_des_mon' => $inf->ttg_des_mon,
                                  'tbd_val_cmb_org' => $inf->tbd_val_cmb_org,
                                  'tbd_val_cmb_nvo' => $inf->tbd_val_cmb_nvo,
                                  'tbd_fec_cmb_org' => $inf->tbd_fec_cmb_org,
                                  'tbd_fec_cmb_nvo' => $inf->tbd_fec_cmb_nvo,
                                  'tbd_fec_mvt_org' => $inf->tbd_fec_mvt_org,
                                  'tbd_fec_mvt_nvo' => $inf->tbd_fec_mvt_nvo,
                                  'tbd_mto_org_org' => $inf->tbd_mto_org_org,
                                  'tbd_mto_org_nvo' => $inf->tbd_mto_org_nvo,
                                  'tbd_mto_pso_org' => $inf->tbd_mto_pso_org,
                                  'tbd_mto_pso_nvo' => $inf->tbd_mto_pso_nvo,
                                  'tbd_mto_pso_dif' => $inf->tbd_mto_pso_dif,                                  
                                  'tbd_cta_bco_org' => $inf->tbd_cta_bco_org,
                                  'tbd_cta_bco_nvo' => $inf->tbd_cta_bco_nvo,
                                  'tmd_des_dpr' => $inf->tmd_des_dpr,
                                  'tbd_obs_dpr' => $inf->tbd_obs_dpr,
                                  'tbd_lgn_bdp' => $inf->tbd_lgn_bdp);

        }   

        $group = groupArray($data_array,'tsp_nom_fan');       

        //Recorro todos los elementos
        for($i=0; $i < count($group); $i++)
        {             

            $Ct = $Ct + 2;

            /*tamaño letra en grilla*/
            $objPHPExcel->getActiveSheet()
                        ->getStyle('B' . $Ct)
                        ->getFont()
                        ->setBold(true)
                        ->setName('Calibri')
                        ->setSize(9); 

            $objPHPExcel->getActiveSheet()->mergeCells('B' . $Ct . ':T' . $Ct);

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('B' . $Ct, $group[$i]['tsp_nom_fan']);

            for($x=0; $x < count($group[$i]['groupeddata']); $x++)
            {             

                $Ct = $Ct + 1;

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('B' . $Ct, $group[$i]['groupeddata'][$x]['tmb_des_bco'])
                            ->setCellValue('C' . $Ct, $group[$i]['groupeddata'][$x]['tbs_num_cta'])  
                            ->setCellValue('D' . $Ct, $group[$i]['groupeddata'][$x]['trf_des_rfl'])
                            ->setCellValue('E' . $Ct, $group[$i]['groupeddata'][$x]['ttg_des_mon'])                    
                            ->setCellValue('F' . $Ct, $group[$i]['groupeddata'][$x]['tbd_val_cmb_org'])
                            ->setCellValue('G' . $Ct, $group[$i]['groupeddata'][$x]['tbd_val_cmb_nvo'])
                            ->setCellValue('H' . $Ct, $group[$i]['groupeddata'][$x]['tbd_fec_cmb_org'])  
                            ->setCellValue('I' . $Ct, $group[$i]['groupeddata'][$x]['tbd_fec_cmb_nvo'])
                            ->setCellValue('J' . $Ct, $group[$i]['groupeddata'][$x]['tbd_fec_mvt_org'])                    
                            ->setCellValue('K' . $Ct, $group[$i]['groupeddata'][$x]['tbd_fec_mvt_nvo'])
                            ->setCellValue('L' . $Ct, $group[$i]['groupeddata'][$x]['tbd_mto_org_org'])
                            ->setCellValue('M' . $Ct, $group[$i]['groupeddata'][$x]['tbd_mto_org_nvo'])  
                            ->setCellValue('N' . $Ct, $group[$i]['groupeddata'][$x]['tbd_mto_pso_org'])
                            ->setCellValue('O' . $Ct, $group[$i]['groupeddata'][$x]['tbd_mto_pso_nvo'])
                            ->setCellValue('P' . $Ct, $group[$i]['groupeddata'][$x]['tbd_mto_pso_dif'])
                            ->setCellValue('Q' . $Ct, $group[$i]['groupeddata'][$x]['tbd_cta_bco_org'])
                            ->setCellValue('R' . $Ct, $group[$i]['groupeddata'][$x]['tbd_cta_bco_nvo'])                     
                            ->setCellValue('S' . $Ct, $group[$i]['groupeddata'][$x]['tmd_des_dpr'])
                            ->setCellValue('T' . $Ct, $group[$i]['groupeddata'][$x]['tbd_obs_dpr'])
                            ->setCellValue('U' . $Ct, $group[$i]['groupeddata'][$x]['tbd_lgn_bdp']);


                $objPHPExcel->getActiveSheet()
                            ->getStyle('H' . $Ct .':'.'K' . $Ct)
                            ->getAlignment()
                            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

                $objPHPExcel->getActiveSheet()
                            ->getStyle('N' . $Ct .':'.'P' . $Ct)
                            ->getNumberFormat()
                            ->setFormatCode('#,##0;[Red]-#,##0');

            } 
        }            
       
                              
        $objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
        //Unir celdas 
        $objPHPExcel->getActiveSheet()->mergeCells('B2:E2');

             
        $aColArr = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U');
        
        foreach ($aColArr as $col) {
            # code...
            $objPHPExcel->getActiveSheet()->getColumnDimension($col)->setAutoSize(true);
        }     
                                            
        $objPHPExcel->getActiveSheet()->setTitle('Exportacion');
        $objPHPExcel->setActiveSheetIndex(0);         
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Listado_de_diferencia.xls"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       
        
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');      
    }

    Public Function fnc_exp_dcn_egi()
    {
        /*[AUT-20190514 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                        
        
        /*[AUT-20190514 : Parametros de Entrada desde ExtJS]*/
        $iOpcCol = $data[0];
        $iAnoMes = $data[1];
        $iCodFlj = $data[2];
		$iCsuMmm = $data[3];
        $iSldIni = $data[4];
        $iSldDap = $data[5];        

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);        
        
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion");                                      
        
        $csu_dcn_enc = $this->mdl_exp_exc->mdl_csu_dcn_egi($iOpcCol,$iAnoMes,$iCodFlj,$iCsuMmm,$iSldIni,$iSldDap);
        $csu_dcn_res = $this->mdl_exp_exc->mdl_csu_dcn_egi(2,$iAnoMes,$iCodFlj,$iCsuMmm,$iSldIni,$iSldDap);
    

        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Decisión Estratégica '.date("d/m/Y"));        
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B2')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(15)
                    ->setBold(true)
                    ->getColor();     


        $Ec = 0;
        $D = '';$E = '';$F = '';$G = '';$H = '';$I = '';$J = '';$K = '';$L = '';$M = '';
        $N = '';$O = '';$P = '';$Q = '';$R = '';$S = '';$T = '';$U = '';$V = '';$W = '';$X = '';
        foreach ($csu_dcn_enc as $enc)
        {
            $Ec = $Ec + 1;
        
            if($Ec === 1)    {$C= $enc->tmp_ano_row;}
            elseif($Ec === 2){$D= $enc->tmp_ano_row;} 
            elseif($Ec === 3){$E= $enc->tmp_ano_row;} 
            elseif($Ec === 4){$F= $enc->tmp_ano_row;} 
            elseif($Ec === 5){$G= $enc->tmp_ano_row;} 
            elseif($Ec === 6){$H= $enc->tmp_ano_row;} 
            elseif($Ec === 7){$I= $enc->tmp_ano_row;} 
            elseif($Ec === 8){$J= $enc->tmp_ano_row;} 
            elseif($Ec === 9){$K= $enc->tmp_ano_row;} 
            elseif($Ec === 10){$L= $enc->tmp_ano_row;} 
            elseif($Ec === 11){$M= $enc->tmp_ano_row;} 
            elseif($Ec === 12){$N= $enc->tmp_ano_row;}
            elseif($Ec === 13){$O= $enc->tmp_ano_row;}  
            elseif($Ec === 14){$P= $enc->tmp_ano_row;}
            elseif($Ec === 15){$Q= $enc->tmp_ano_row;}
            elseif($Ec === 16){$R= $enc->tmp_ano_row;}
            elseif($Ec === 17){$S= $enc->tmp_ano_row;}
            elseif($Ec === 18){$T= $enc->tmp_ano_row;}
            elseif($Ec === 19){$U= $enc->tmp_ano_row;}
            elseif($Ec === 20){$V= $enc->tmp_ano_row;}
            elseif($Ec === 21){$W= $enc->tmp_ano_row;}

        }
		
		$FljGri = '';
		if($iCsuMmm === 0){
			$FljGri = '$';
		}
		else{
			$FljGri = 'Cifras en MM$';
		}
    
        /*Centrar Celdas*/            
        $objPHPExcel->getActiveSheet()->getStyle('B5:W5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('B5', 'Flujo '.$FljGri)                    
                    ->setCellValue('C5', $C)
                    ->setCellValue('D5', $D)
                    ->setCellValue('E5', $E)
                    ->setCellValue('F5', $F)
                    ->setCellValue('G5', $G)
                    ->setCellValue('H5', $H)
                    ->setCellValue('I5', $I)
                    ->setCellValue('J5', $J)
                    ->setCellValue('K5', $K)
                    ->setCellValue('L5', $L)
                    ->setCellValue('M5', $M)
                    ->setCellValue('N5', $N)
                    ->setCellValue('O5', $O)
                    ->setCellValue('P5', $P)
                    ->setCellValue('Q5', $Q)
                    ->setCellValue('R5', $R)
                    ->setCellValue('S5', $S)
                    ->setCellValue('T5', $T)
                    ->setCellValue('U5', $U)
                    ->setCellValue('V5', $V)
                    ->setCellValue('W5', $W);                    

        //Configuración de tipos de letra                         
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:W5')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(true)        
                    ->getColor()
                    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
                    
        //fondo a celda
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:W5')
                    ->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('&H808080');         

        $Ct = 5;
        
        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(false)        
                    ->getColor();   

        foreach ($csu_dcn_res as $res)
        {

            $data_array[] = array('tmp_tip_cta' => $res->tmp_tip_cta,                                  
                                  'tae_des_aeg' => $res->tae_des_aeg,
                                  'tmp_fec_001' => $res->tmp_fec_001,
                                  'tmp_fec_002' => $res->tmp_fec_002,
                                  'tmp_fec_003' => $res->tmp_fec_003,
                                  'tmp_fec_004' => $res->tmp_fec_004,
                                  'tmp_fec_005' => $res->tmp_fec_005,
                                  'tmp_fec_006' => $res->tmp_fec_006,
                                  'tmp_fec_007' => $res->tmp_fec_007,
                                  'tmp_fec_008' => $res->tmp_fec_008,
                                  'tmp_fec_009' => $res->tmp_fec_009,
                                  'tmp_fec_010' => $res->tmp_fec_010,
                                  'tmp_fec_011' => $res->tmp_fec_011,
                                  'tmp_fec_012' => $res->tmp_fec_012,
                                  'tmp_fec_013' => $res->tmp_fec_013,
                                  'tmp_fec_014' => $res->tmp_fec_014,
                                  'tmp_fec_015' => $res->tmp_fec_015,
                                  'tmp_fec_016' => $res->tmp_fec_016,
                                  'tmp_fec_017' => $res->tmp_fec_017,
                                  'tmp_fec_018' => $res->tmp_fec_018,
                                  'tmp_fec_019' => $res->tmp_fec_019,
                                  'tmp_fec_020' => $res->tmp_fec_020,                                 
                                  'tmp_fec_021' => $res->tmp_fec_021);

        }  

        $group = groupArray($data_array,'tmp_tip_cta');       

        //Recorro todos los elementos
        for($i=0; $i < count($group); $i++)
        {   

            if($group[$i]['tmp_tip_cta'] === 'INGRESO'){

                $Ct = 10;                         

            }

            if($group[$i]['tmp_tip_cta'] === 'EGRESO'){
                
                $Ct = $Cti;
                $Ct = $Ct + 2;                         

            }

           if($group[$i]['tmp_tip_cta'] === 'A.'){ //SALDO CAJA GENERADO

                $Ct = $Cte;
                $Ct = $Ct + 8;             

            }

            if($group[$i]['tmp_tip_cta'] === 'B.'){ //DEF/SUP CAJA ACUMULADA

                $Ct = $Cte;
                $Ct = $Ct + 5;                        

            }

            if($group[$i]['tmp_tip_cta'] === 'C.'){ //ingresos - egresos

                $Ct = $Cte;
                $Ct = $Ct + 2;                        

            }

            if($group[$i]['tmp_tip_cta'] === 'Z.'){

                $Ct = 7;                         

            }            

            /*tamaño letra en grilla*/
            $objPHPExcel->getActiveSheet()
                        ->getStyle('B' . $Ct)
                        ->getFont()
                        ->setBold(true)
                        ->setName('Calibri')
                        ->setSize(9); 

            $objPHPExcel->getActiveSheet()->mergeCells('B' . $Ct . ':W' . $Ct);

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('B' . $Ct, $group[$i]['tmp_tip_cta']); 

            for($x=0; $x < count($group[$i]['groupeddata']); $x++)
            {             

                $Ct = $Ct + 1;

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('B' . $Ct, $group[$i]['groupeddata'][$x]['tae_des_aeg'])
                            ->setCellValue('C' . $Ct, $group[$i]['groupeddata'][$x]['tmp_fec_001'])  
                            ->setCellValue('D' . $Ct, $group[$i]['groupeddata'][$x]['tmp_fec_002'])
                            ->setCellValue('E' . $Ct, $group[$i]['groupeddata'][$x]['tmp_fec_003'])                    
                            ->setCellValue('F' . $Ct, $group[$i]['groupeddata'][$x]['tmp_fec_004'])
                            ->setCellValue('G' . $Ct, $group[$i]['groupeddata'][$x]['tmp_fec_005'])
                            ->setCellValue('H' . $Ct, $group[$i]['groupeddata'][$x]['tmp_fec_006'])  
                            ->setCellValue('I' . $Ct, $group[$i]['groupeddata'][$x]['tmp_fec_007'])
                            ->setCellValue('J' . $Ct, $group[$i]['groupeddata'][$x]['tmp_fec_008'])                    
                            ->setCellValue('K' . $Ct, $group[$i]['groupeddata'][$x]['tmp_fec_009'])
                            ->setCellValue('L' . $Ct, $group[$i]['groupeddata'][$x]['tmp_fec_010'])
                            ->setCellValue('M' . $Ct, $group[$i]['groupeddata'][$x]['tmp_fec_011'])  
                            ->setCellValue('N' . $Ct, $group[$i]['groupeddata'][$x]['tmp_fec_012'])
                            ->setCellValue('O' . $Ct, $group[$i]['groupeddata'][$x]['tmp_fec_013'])
                            ->setCellValue('P' . $Ct, $group[$i]['groupeddata'][$x]['tmp_fec_014'])
                            ->setCellValue('Q' . $Ct, $group[$i]['groupeddata'][$x]['tmp_fec_015'])                     
                            ->setCellValue('R' . $Ct, $group[$i]['groupeddata'][$x]['tmp_fec_016'])
                            ->setCellValue('S' . $Ct, $group[$i]['groupeddata'][$x]['tmp_fec_017'])
                            ->setCellValue('T' . $Ct, $group[$i]['groupeddata'][$x]['tmp_fec_018'])
                            ->setCellValue('U' . $Ct, $group[$i]['groupeddata'][$x]['tmp_fec_019'])
                            ->setCellValue('V' . $Ct, $group[$i]['groupeddata'][$x]['tmp_fec_020'])
                            ->setCellValue('W' . $Ct, $group[$i]['groupeddata'][$x]['tmp_fec_021']);                           

							if($iCsuMmm === 0){
								$objPHPExcel->getActiveSheet()
											->getStyle('C' . $Ct .':'.'W' . $Ct)
											->getNumberFormat()
											->setFormatCode('$#,##0;[Red]-$#,##0');
							}

            } 

            if($group[$i]['tmp_tip_cta'] === 'INGRESO'){

                $Cti = $Ct;
            }

            if($group[$i]['tmp_tip_cta'] === 'EGRESO'){

                $Cte = $Ct;
            }
        }     
                              
        $objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
        //Unir celdas 
        $objPHPExcel->getActiveSheet()->mergeCells('B2:X2');

        $aColArr = array('B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W');
        
        foreach ($aColArr as $col) {
            # code...
            $objPHPExcel->getActiveSheet()->getColumnDimension($col)->setAutoSize(true);
        }   
                     
        $objPHPExcel->getActiveSheet()->setTitle('Exportacion');
        $objPHPExcel->setActiveSheetIndex(0);         
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Decision Estrategica "'.date("d/m/Y").'".xls"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       
        
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');      
    }     

    Public Function fnc_exp_exc_crl()
    {
        /*[AUT-20201214 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                        
        
        /*[AUT-20201214 : Parametros de Entrada desde ExtJS]*/
        $iCodCrd = $data[0];
        $iEstCrl = $data[1];
        $iFemIni = $data[2];
        $iFemTer = $data[3];
        $iEmiPor = $data[4];
        $iUsrSol = $data[5];
        $iSdpOrg = $data[6];
        $iBcoOrg = $data[7];
        $iFerIni = $data[8];
        $iFerTer = $data[9];
        $iSdpDtn = $data[10];
        $iBcoDtn = $data[11];

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);        
        
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion");                                      
        
        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado de Cuentas Relacionadas');        
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B2')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(15)
                    ->setBold(true)
                    ->getColor();        
               
        /*Centrar Celdas*/            
        $objPHPExcel->getActiveSheet()->getStyle('B5:I5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('B5', 'N° Traspaso')
                    ->setCellValue('C5', 'Estado')
                    ->setCellValue('D5', 'Fecha Traspaso')
                    ->setCellValue('E5', 'Empresa Origen')
                    ->setCellValue('F5', 'Banco Origen')
                    ->setCellValue('G5', 'Monto')
                    ->setCellValue('H5', 'Empresa de Destino')                    
                    ->setCellValue('I5', 'Banco de Destino');                    

        //Configuración de tipos de letra                         
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:I5')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(true)        
                    ->getColor()
                    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
                    
        //fondo a celda
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:I5')
                    ->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('&H808080');         

        $cuentas = $this->mdl_exp_exc->mdl_csu_tsp_crl($iCodCrd,
                                                       $iEstCrl,
                                                       ($iFemIni <> '' ?  $iFemIni . ' 00:00:00' : ''),
                                                       ($iFemTer <> '' ?  $iFemTer . ' 23:59:59' : ''),
                                                       $iEmiPor,
                                                       $iUsrSol,
                                                       $iSdpOrg,
                                                       $iBcoOrg,
                                                       ($iFerIni <> '' ?  $iFerIni . ' 00:00:00' : ''),
                                                       ($iFerTer <> '' ?  $iFerTer . ' 23:59:59' : ''),                                                      
                                                       $iSdpDtn,
                                                       $iBcoDtn);

        $Ct = 5;
        
        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(false)        
                    ->getColor();   
           
        foreach ($cuentas as $crl)
        {
            $Ct = $Ct + 1;

            $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('B' . $Ct, $crl->ttc_cod_crd)
                            ->setCellValue('C' . $Ct, $crl->tec_des_crl)  
                            ->setCellValue('D' . $Ct, ($crl->tdt_fec_rtr <> '00/00/0000' ? $crl->tdt_fec_rtr : ''))                    
                            ->setCellValue('E' . $Ct, $crl->rzn_scl_org)                            
                            ->setCellValue('F' . $Ct, $crl->des_bco_org)                           
                            ->setCellValue('G' . $Ct, $crl->tdt_mto_org)                           
                            ->setCellValue('H' . $Ct, $crl->rzn_scl_dtn)                           
                            ->setCellValue('I' . $Ct, $crl->des_bco_dtn);                           

            $objPHPExcel->getActiveSheet()
                        ->getStyle('C' . $Ct)
                        ->getFont()
                        ->setName('Calibri')
                        ->setSize(8)
                        ->setBold(true)        
                        ->getColor()
                        ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);  

            $objPHPExcel->getActiveSheet()
                        ->getStyle('C' . $Ct)
                        ->getFill()
                        ->applyFromArray(array(
                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                'startcolor' => array(
                                                    'rgb' => $crl->tec_bck_col
                                                )
                                ));   
            
            $objPHPExcel->getActiveSheet()->getStyle('B' . $Ct .':'.'D' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle('G' . $Ct )->getNumberFormat()->setFormatCode('$#,##0;[Red]-$#,##0');           

        }   
                              
        $objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
        //Unir celdas 
        $objPHPExcel->getActiveSheet()->mergeCells('B2:D2');
             
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(10);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);         
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true); 
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true); 
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true); 
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true); 
                                            
        $objPHPExcel->getActiveSheet()->setTitle('Exportacion');
        $objPHPExcel->setActiveSheetIndex(0);         
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Listado_de_Cuentas_Relacionadas.xls"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       
        
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');      
    }

	Public Function fnc_exp_det_pry()
    {
        /*[AUT-20190822 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                        
        
        /*[AUT-20190826 : Parametros de Entrada desde ExtJS]*/
        $iCodAeg = $data[0];
        $iMesAno = $data[1];
        $iFlgpry = $data[2];
        $iFecIniMvt = $data[3];
        $iFecFinMvt = $data[4];
        $iCodRfl = $data[5];

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);        
        
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion");                                      
        
        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado de Decisión Estratégica Detalle');        
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B2')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(15)
                    ->setBold(true)
                    ->getColor();        
               
        /*Centrar Celdas*/            
        $objPHPExcel->getActiveSheet()->getStyle('B5:O5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
        $objPHPExcel->setActiveSheetIndex(0)
		            ->setCellValue('B5', 'Tipo')
                    ->setCellValue('C5', 'Flujo $$MM')
                    ->setCellValue('D5', 'Origen')
                    ->setCellValue('E5', 'Moneda Origen')
					->setCellValue('F5', 'Monto Origen')
                    ->setCellValue('G5', 'Monto $')
                    ->setCellValue('H5', 'Fecha de Movimiento')
					->setCellValue('I5', 'Fecha de Registro')
					->setCellValue('J5', 'Usuario')
					->setCellValue('K5', 'Empresa')
					->setCellValue('L5', 'Banco')
					->setCellValue('M5', 'Tipo de Cuenta')
					->setCellValue('N5', 'N° de Cuenta')
					->setCellValue('O5', 'Observación de Origen');                    

        //Configuración de tipos de letra                         
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:O5')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(true)        
                    ->getColor()
                    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
                    
        //fondo a celda
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:O5')
                    ->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('&H808080');         
        
        $csu_det_pry = $this->mdl_exp_exc->mdl_csu_det_pry($iCodAeg,$iMesAno,$iFlgpry,
                                                        ($iFecIniMvt <> '' ?  $iFecIniMvt . ' 00:00:00' : ''),
                                                        ($iFecFinMvt <> '' ?  $iFecFinMvt . ' 23:59:59' : ''),
                                                        $iCodRfl);
														
														

        $Ct = 5;
        
        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(false)        
                    ->getColor();   
           
        foreach ($csu_det_pry as $pry)
        {
            $Ct = $Ct + 1;

            $objPHPExcel->setActiveSheetIndex(0)
							->setCellValue('B' . $Ct, $pry->tmp_tip_cta)
                            ->setCellValue('C' . $Ct, $pry->tae_des_aeg)
                            ->setCellValue('D' . $Ct, $pry->tmp_tip_org)  
                            ->setCellValue('E' . $Ct, $pry->tdp_tip_mon)
                            ->setCellValue('F' . $Ct, $pry->tdp_mto_org)                    
                            ->setCellValue('G' . $Ct, $pry->tdp_mto_pso)
							->setCellValue('H' . $Ct, $pry->tdp_fec_mvt)
							->setCellValue('I' . $Ct, $pry->tdp_fec_reg)
							->setCellValue('J' . $Ct, $pry->tmu_lgn_usr)
							->setCellValue('K' . $Ct, $pry->tsp_nom_fan)
							->setCellValue('L' . $Ct, $pry->tmb_des_bco)
							->setCellValue('M' . $Ct, $pry->tbs_tip_cta)
							->setCellValue('N' . $Ct, $pry->tbs_num_cta)
							->setCellValue('O' . $Ct, $pry->tdp_obs_org);                            

            
            $objPHPExcel->getActiveSheet()->getStyle('E' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);   
            $objPHPExcel->getActiveSheet()->getStyle('F' . $Ct .':'.'G' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);      
			$objPHPExcel->getActiveSheet()->getStyle('H' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);   
			$objPHPExcel->getActiveSheet()->getStyle('I' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);   	

			$objPHPExcel->getActiveSheet()->getStyle('G' . $Ct )->getNumberFormat()->setFormatCode('#,##0.00;[Red]-$#,##0.00'); 			

        }   
                              
        $objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
        //Unir celdas 
        $objPHPExcel->getActiveSheet()->mergeCells('B2:D2');
             
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);         
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true); 
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);
                                            
        $objPHPExcel->getActiveSheet()->setTitle('Exportacion');
        $objPHPExcel->setActiveSheetIndex(0);         
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Listado de Decisión Estratégica Detalle.xls"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       
        
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');      
    }   


    Public Function fnc_exp_exc_lbr_rem()
    {
        /*[AUT-20201228 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                        
        
        /*[AUT-20201228 : Parametros de Entrada desde ExtJS]*/
        $iTipFlj = $data[0];
        $iCodSdp = $data[1];
        $iPedLiq = $data[2];    

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);        
        
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion");                                      
        
        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado de Renumeraciones');        
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B2')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(15)
                    ->setBold(true)
                    ->getColor();        
               
        /*Centrar Celdas*/            
        $objPHPExcel->getActiveSheet()->getStyle('B5:C5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
        $objPHPExcel->setActiveSheetIndex(0)                    
                    ->setCellValue('B5', 'Registro en Flujo')
                    ->setCellValue('C5', 'Monto');                                 

        //Configuración de tipos de letra                         
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:C5')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(true)        
                    ->getColor()
                    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
                    
        //fondo a celda
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:C5')
                    ->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('&H808080');         

        $renumeracion = $this->mdl_exp_exc->mdl_csu_lbr_rem($iTipFlj,                                                                                                                           
                                                            $iCodSdp,                                                      
                                                            $iPedLiq);

        $Ct = 5;
        
        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(false)        
                    ->getColor(); 
         
       
        foreach ($renumeracion as $rem)
        {

            $data_array[] = array('tsp_rzn_scl' => $rem->tsp_rzn_scl,                                  
                                  'trf_des_rfl' => $rem->trf_des_rfl,
                                  'tls_mnt_val' => $rem->tls_mnt_val);

        }   

        $group = groupArray($data_array,'tsp_rzn_scl');       

        //Recorro todos los elementos
        for($i=0; $i < count($group); $i++)
        {             
            $sum = 0;
            $Ct = $Ct + 2;

            /*tamaño letra en grilla*/
            $objPHPExcel->getActiveSheet()
                        ->getStyle('B' . $Ct)
                        ->getFont()
                        ->setBold(true)
                        ->setName('Calibri')
                        ->setSize(9); 

            $objPHPExcel->getActiveSheet()->mergeCells('B' . $Ct . ':G' . $Ct);

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('B' . $Ct, $group[$i]['tsp_rzn_scl']);

            for($x=0; $x < count($group[$i]['groupeddata']); $x++)
            {             

                $Ct = $Ct + 1;

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('B' . $Ct, $group[$i]['groupeddata'][$x]['trf_des_rfl'])
                            ->setCellValue('C' . $Ct, $group[$i]['groupeddata'][$x]['tls_mnt_val']);

                $sum = $sum + $group[$i]['groupeddata'][$x]['tls_mnt_val'];

                $objPHPExcel->getActiveSheet()
                            ->getStyle('C' . $Ct)
                            ->getNumberFormat()
                            ->setFormatCode('#,##0;[Red]-#,##0');

            } 

            $Ct = $Ct + 1;

            $objPHPExcel->getActiveSheet()
                        ->getStyle('C' . $Ct)
                        ->getNumberFormat()
                        ->setFormatCode('#,##0;[Red]-#,##0');

            $objPHPExcel->getActiveSheet()
                        ->getStyle('B' . $Ct . ':' . 'C' . $Ct)
                        ->getFont()
                        ->setBold(true)
                        ->setName('Calibri')
                        ->setSize(9); 

            $objPHPExcel->setActiveSheetIndex(0)->setCellValue('B' . $Ct, 'TOTAL');
            $objPHPExcel->setActiveSheetIndex(0)->setCellValue('C' . $Ct, $sum);
                            
        }            
       
                              
        $objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
        //Unir celdas 
        $objPHPExcel->getActiveSheet()->mergeCells('B2:E2');

             
        $aColArr = array('A','B','C');
        
        foreach ($aColArr as $col) {
            # code...
            $objPHPExcel->getActiveSheet()->getColumnDimension($col)->setAutoSize(true);
        }     
                                            
        $objPHPExcel->getActiveSheet()->setTitle('Exportacion');
        $objPHPExcel->setActiveSheetIndex(0);         
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Listado_de_renumeraciones.xls"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       
        
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');      
    } 

    Public Function fnc_exp_exc_rie()
    {
        /*[AUT-20161018 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                

        /*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/
        $iCodRie = $data[0];
        $iCodEst = $data[1];
        $iCodFip = $data[2];        
        $iPedDsd = $data[3];
        $iPedHst = $data[4];
        $iRutEnt = $data[5];        
        $iRutAdm = $data[6];
        $iNomAdm = $data[7];
        $iFanAdm = $data[8];

        /** CABECERAS **/
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);        

        ini_set("memory_limit", "-1");
        set_time_limit(0);  
        
        //NUEVO OBJETO GENERAL
        $objPHPExcel = new PHPExcel();

        //PROPIEDADES METADATOS
        $objPHPExcel->getProperties()->setCreator(CREADOR)
                                     ->setLastModifiedBy(MODIFICA)
                                     ->setTitle("Office Exportacion")
                                     ->setSubject("Office Exportacion")
                                     ->setDescription("Office Exportacion")
                                     ->setKeywords("office 2007 openxml php")
                                     ->setCategory("Office Exportacion");                                 

        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado de Riesgo');        
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B2')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(15)
                    ->setBold(true)
                    ->getColor();        


        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('B5', 'Codigo')
                    ->setCellValue('C5', 'Nombre del FIP')                    
                    ->setCellValue('D5', 'Estado')                    
                    ->setCellValue('E5', 'Tipo de FIP')                    
                    ->setCellValue('F5', 'Periodo Entidad Desde')    
                    ->setCellValue('G5', 'Periodo Entidad Hasta')  
                    ->setCellValue('H5', 'RUT Entidad')                                                    
                    ->setCellValue('I5', 'Costo de Adm.')                                        
                    ->setCellValue('J5', 'RUT Admin')
                    ->setCellValue('K5', 'Nombre / Rzn. Soc.');                   

        //Configuración de tipos de letra                         
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:K5')
                    ->getFont()
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(true)        
                    ->getColor()
                    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        

        //fondo a celda
        $objPHPExcel->getActiveSheet()
                    ->getStyle('B5:K5')
                    ->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('&H808080');         

        $riesgo = $this
            ->mdl_exp_exc
            ->mdl_csu_mae_rie($iCodRie,
                              $iCodEst,
                              $iCodFip,                              
                              $iPedDsd,
                              $iPedHst,
                              $iRutEnt,                              
                              $iRutAdm,
                              $iNomAdm,
                              $iFanAdm);
        
        $Ct = 5;

        /*tamaño letra en grilla*/
        $objPHPExcel->getDefaultStyle()
        ->getFont()                    
        ->setName('Calibri')
        ->setSize(8)
        ->setBold(false)        
        ->getColor();   

        foreach ($riesgo as $rie)
        {
            $Ct = $Ct + 1;

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('B' . $Ct, $rie->tmr_cod_rie)
                        ->setCellValue('C' . $Ct, $rie->tmr_nom_fip)
                        ->setCellValue('D' . $Ct, $rie->ter_des_est)
                        ->setCellValue('E' . $Ct, $rie->ttf_des_fip)            
                        ->setCellValue('F' . $Ct, $rie->tmr_ped_dsd)
                        ->setCellValue('G' . $Ct, $rie->tmr_ped_hst)
                        ->setCellValue('H' . $Ct, $rie->cnt_rut_ent)            
                        ->setCellValue('I' . $Ct, $rie->tmr_mnt_adm)                                    
                        ->setCellValue('J' . $Ct, $rie->cnt_rut_adm)
                        ->setCellValue('K' . $Ct, $rie->tmr_nom_adm);
                        

            $objPHPExcel->getActiveSheet()
                        ->getStyle('D' . $Ct)
                        ->getFill()
                        ->applyFromArray(array(
                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                'startcolor' => array(
                                                    'rgb' => $rie->ter_bck_col
                                                )
                                ));               

            $objPHPExcel->getActiveSheet()->getStyle('B' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER); 
            $objPHPExcel->getActiveSheet()->getStyle('D' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);            
            $objPHPExcel->getActiveSheet()->getStyle('F' . $Ct .':'.'H' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle('I' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);  
            $objPHPExcel->getActiveSheet()->getStyle('I' . $Ct )->getNumberFormat()->setFormatCode('$#,##0;[Red]-$#,##0');  
            $objPHPExcel->getActiveSheet()->getStyle('J' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);              
        }   

        $objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
        //Unir celdas 
        $objPHPExcel->getActiveSheet()->mergeCells('B2:D2');

        $aColArr = array('A','B','C','D','E','F','G','H','I','J','K');
        
        foreach ($aColArr as $col) {
            # code...
            $objPHPExcel->getActiveSheet()->getColumnDimension($col)->setAutoSize(true);
        }   
        
        $objPHPExcel->getActiveSheet()->setTitle('Exportacion');
        $objPHPExcel->setActiveSheetIndex(0);         

        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Listado_de_Riesgo.xls"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');       

        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');      
    }
}